/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.ReplicationEndpointTypeValue;
import software.amazon.awssdk.services.databasemigration.transform.SupportedEndpointTypeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportedEndpointType
implements StructuredPojo,
ToCopyableBuilder<Builder, SupportedEndpointType> {
    private final String engineName;
    private final Boolean supportsCDC;
    private final String endpointType;
    private final String engineDisplayName;

    private SupportedEndpointType(BuilderImpl builder) {
        this.engineName = builder.engineName;
        this.supportsCDC = builder.supportsCDC;
        this.endpointType = builder.endpointType;
        this.engineDisplayName = builder.engineDisplayName;
    }

    public String engineName() {
        return this.engineName;
    }

    public Boolean supportsCDC() {
        return this.supportsCDC;
    }

    public ReplicationEndpointTypeValue endpointType() {
        return ReplicationEndpointTypeValue.fromValue(this.endpointType);
    }

    public String endpointTypeAsString() {
        return this.endpointType;
    }

    public String engineDisplayName() {
        return this.engineDisplayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportsCDC());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineDisplayName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedEndpointType)) {
            return false;
        }
        SupportedEndpointType other = (SupportedEndpointType)obj;
        return Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.supportsCDC(), other.supportsCDC()) && Objects.equals(this.endpointTypeAsString(), other.endpointTypeAsString()) && Objects.equals(this.engineDisplayName(), other.engineDisplayName());
    }

    public String toString() {
        return ToString.builder((String)"SupportedEndpointType").add("EngineName", (Object)this.engineName()).add("SupportsCDC", (Object)this.supportsCDC()).add("EndpointType", (Object)this.endpointTypeAsString()).add("EngineDisplayName", (Object)this.engineDisplayName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "SupportsCDC": {
                return Optional.ofNullable(clazz.cast(this.supportsCDC()));
            }
            case "EndpointType": {
                return Optional.ofNullable(clazz.cast(this.endpointTypeAsString()));
            }
            case "EngineDisplayName": {
                return Optional.ofNullable(clazz.cast(this.engineDisplayName()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SupportedEndpointTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String engineName;
        private Boolean supportsCDC;
        private String endpointType;
        private String engineDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedEndpointType model) {
            this.engineName(model.engineName);
            this.supportsCDC(model.supportsCDC);
            this.endpointType(model.endpointType);
            this.engineDisplayName(model.engineDisplayName);
        }

        public final String getEngineName() {
            return this.engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        public final Boolean getSupportsCDC() {
            return this.supportsCDC;
        }

        @Override
        public final Builder supportsCDC(Boolean supportsCDC) {
            this.supportsCDC = supportsCDC;
            return this;
        }

        public final void setSupportsCDC(Boolean supportsCDC) {
            this.supportsCDC = supportsCDC;
        }

        public final String getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(ReplicationEndpointTypeValue endpointType) {
            this.endpointType(endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getEngineDisplayName() {
            return this.engineDisplayName;
        }

        @Override
        public final Builder engineDisplayName(String engineDisplayName) {
            this.engineDisplayName = engineDisplayName;
            return this;
        }

        public final void setEngineDisplayName(String engineDisplayName) {
            this.engineDisplayName = engineDisplayName;
        }

        public SupportedEndpointType build() {
            return new SupportedEndpointType(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SupportedEndpointType> {
        public Builder engineName(String var1);

        public Builder supportsCDC(Boolean var1);

        public Builder endpointType(String var1);

        public Builder endpointType(ReplicationEndpointTypeValue var1);

        public Builder engineDisplayName(String var1);
    }
}

