/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.databasemigration.model.AvailabilityZone;
import software.amazon.awssdk.services.databasemigration.transform.SubnetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Subnet
implements StructuredPojo,
ToCopyableBuilder<Builder, Subnet> {
    private final String subnetIdentifier;
    private final AvailabilityZone subnetAvailabilityZone;
    private final String subnetStatus;

    private Subnet(BuilderImpl builder) {
        this.subnetIdentifier = builder.subnetIdentifier;
        this.subnetAvailabilityZone = builder.subnetAvailabilityZone;
        this.subnetStatus = builder.subnetStatus;
    }

    public String subnetIdentifier() {
        return this.subnetIdentifier;
    }

    public AvailabilityZone subnetAvailabilityZone() {
        return this.subnetAvailabilityZone;
    }

    public String subnetStatus() {
        return this.subnetStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetStatus());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Subnet)) {
            return false;
        }
        Subnet other = (Subnet)obj;
        return Objects.equals(this.subnetIdentifier(), other.subnetIdentifier()) && Objects.equals(this.subnetAvailabilityZone(), other.subnetAvailabilityZone()) && Objects.equals(this.subnetStatus(), other.subnetStatus());
    }

    public String toString() {
        return ToString.builder((String)"Subnet").add("SubnetIdentifier", (Object)this.subnetIdentifier()).add("SubnetAvailabilityZone", (Object)this.subnetAvailabilityZone()).add("SubnetStatus", (Object)this.subnetStatus()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubnetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.subnetIdentifier()));
            }
            case "SubnetAvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.subnetAvailabilityZone()));
            }
            case "SubnetStatus": {
                return Optional.ofNullable(clazz.cast(this.subnetStatus()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubnetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String subnetIdentifier;
        private AvailabilityZone subnetAvailabilityZone;
        private String subnetStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(Subnet model) {
            this.subnetIdentifier(model.subnetIdentifier);
            this.subnetAvailabilityZone(model.subnetAvailabilityZone);
            this.subnetStatus(model.subnetStatus);
        }

        public final String getSubnetIdentifier() {
            return this.subnetIdentifier;
        }

        @Override
        public final Builder subnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
            return this;
        }

        public final void setSubnetIdentifier(String subnetIdentifier) {
            this.subnetIdentifier = subnetIdentifier;
        }

        public final AvailabilityZone.Builder getSubnetAvailabilityZone() {
            return this.subnetAvailabilityZone != null ? this.subnetAvailabilityZone.toBuilder() : null;
        }

        @Override
        public final Builder subnetAvailabilityZone(AvailabilityZone subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone;
            return this;
        }

        public final void setSubnetAvailabilityZone(AvailabilityZone.BuilderImpl subnetAvailabilityZone) {
            this.subnetAvailabilityZone = subnetAvailabilityZone != null ? subnetAvailabilityZone.build() : null;
        }

        public final String getSubnetStatus() {
            return this.subnetStatus;
        }

        @Override
        public final Builder subnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
            return this;
        }

        public final void setSubnetStatus(String subnetStatus) {
            this.subnetStatus = subnetStatus;
        }

        public Subnet build() {
            return new Subnet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Subnet> {
        public Builder subnetIdentifier(String var1);

        public Builder subnetAvailabilityZone(AvailabilityZone var1);

        default public Builder subnetAvailabilityZone(Consumer<AvailabilityZone.Builder> subnetAvailabilityZone) {
            return this.subnetAvailabilityZone((AvailabilityZone)((AvailabilityZone.Builder)AvailabilityZone.builder().applyMutation(subnetAvailabilityZone)).build());
        }

        public Builder subnetStatus(String var1);
    }
}

