/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationRequest;
import software.amazon.awssdk.services.databasemigration.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyReplicationInstanceRequest
extends DatabaseMigrationRequest
implements ToCopyableBuilder<Builder, ModifyReplicationInstanceRequest> {
    private final String replicationInstanceArn;
    private final Integer allocatedStorage;
    private final Boolean applyImmediately;
    private final String replicationInstanceClass;
    private final List<String> vpcSecurityGroupIds;
    private final String preferredMaintenanceWindow;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean allowMajorVersionUpgrade;
    private final Boolean autoMinorVersionUpgrade;
    private final String replicationInstanceIdentifier;

    private ModifyReplicationInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.allocatedStorage = builder.allocatedStorage;
        this.applyImmediately = builder.applyImmediately;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.allowMajorVersionUpgrade = builder.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public Boolean applyImmediately() {
        return this.applyImmediately;
    }

    public String replicationInstanceClass() {
        return this.replicationInstanceClass;
    }

    public List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Boolean multiAZ() {
        return this.multiAZ;
    }

    public String engineVersion() {
        return this.engineVersion;
    }

    public Boolean allowMajorVersionUpgrade() {
        return this.allowMajorVersionUpgrade;
    }

    public Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String replicationInstanceIdentifier() {
        return this.replicationInstanceIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.applyImmediately());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowMajorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReplicationInstanceRequest)) {
            return false;
        }
        ModifyReplicationInstanceRequest other = (ModifyReplicationInstanceRequest)((Object)obj);
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.applyImmediately(), other.applyImmediately()) && Objects.equals(this.replicationInstanceClass(), other.replicationInstanceClass()) && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.allowMajorVersionUpgrade(), other.allowMajorVersionUpgrade()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.replicationInstanceIdentifier(), other.replicationInstanceIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"ModifyReplicationInstanceRequest").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("ApplyImmediately", (Object)this.applyImmediately()).add("ReplicationInstanceClass", (Object)this.replicationInstanceClass()).add("VpcSecurityGroupIds", this.vpcSecurityGroupIds()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("AllowMajorVersionUpgrade", (Object)this.allowMajorVersionUpgrade()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("ReplicationInstanceIdentifier", (Object)this.replicationInstanceIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "ApplyImmediately": {
                return Optional.ofNullable(clazz.cast(this.applyImmediately()));
            }
            case "ReplicationInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceClass()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AllowMajorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowMajorVersionUpgrade()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "ReplicationInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationRequest.BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private Integer allocatedStorage;
        private Boolean applyImmediately;
        private String replicationInstanceClass;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String preferredMaintenanceWindow;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean allowMajorVersionUpgrade;
        private Boolean autoMinorVersionUpgrade;
        private String replicationInstanceIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyReplicationInstanceRequest model) {
            super(model);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.allocatedStorage(model.allocatedStorage);
            this.applyImmediately(model.applyImmediately);
            this.replicationInstanceClass(model.replicationInstanceClass);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.allowMajorVersionUpgrade(model.allowMajorVersionUpgrade);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.replicationInstanceIdentifier(model.replicationInstanceIdentifier);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        public final Boolean getApplyImmediately() {
            return this.applyImmediately;
        }

        @Override
        public final Builder applyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
            return this;
        }

        public final void setApplyImmediately(Boolean applyImmediately) {
            this.applyImmediately = applyImmediately;
        }

        public final String getReplicationInstanceClass() {
            return this.replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            return this.vpcSecurityGroupIds;
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public final Boolean getAllowMajorVersionUpgrade() {
            return this.allowMajorVersionUpgrade;
        }

        @Override
        public final Builder allowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
            return this;
        }

        public final void setAllowMajorVersionUpgrade(Boolean allowMajorVersionUpgrade) {
            this.allowMajorVersionUpgrade = allowMajorVersionUpgrade;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        public final String getReplicationInstanceIdentifier() {
            return this.replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyReplicationInstanceRequest build() {
            return new ModifyReplicationInstanceRequest(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationRequest.Builder,
    CopyableBuilder<Builder, ModifyReplicationInstanceRequest> {
        public Builder replicationInstanceArn(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder applyImmediately(Boolean var1);

        public Builder replicationInstanceClass(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder allowMajorVersionUpgrade(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder replicationInstanceIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

