/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.TableStatistics;
import software.amazon.awssdk.services.databasemigration.model.TableStatisticsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTableStatisticsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeTableStatisticsResponse> {
    private final String replicationTaskArn;
    private final List<TableStatistics> tableStatistics;
    private final String marker;

    private DescribeTableStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationTaskArn = builder.replicationTaskArn;
        this.tableStatistics = builder.tableStatistics;
        this.marker = builder.marker;
    }

    public String replicationTaskArn() {
        return this.replicationTaskArn;
    }

    public List<TableStatistics> tableStatistics() {
        return this.tableStatistics;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableStatisticsResponse)) {
            return false;
        }
        DescribeTableStatisticsResponse other = (DescribeTableStatisticsResponse)((Object)obj);
        return Objects.equals(this.replicationTaskArn(), other.replicationTaskArn()) && Objects.equals(this.tableStatistics(), other.tableStatistics()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTableStatisticsResponse").add("ReplicationTaskArn", (Object)this.replicationTaskArn()).add("TableStatistics", this.tableStatistics()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationTaskArn": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskArn()));
            }
            case "TableStatistics": {
                return Optional.ofNullable(clazz.cast(this.tableStatistics()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String replicationTaskArn;
        private List<TableStatistics> tableStatistics = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableStatisticsResponse model) {
            super(model);
            this.replicationTaskArn(model.replicationTaskArn);
            this.tableStatistics(model.tableStatistics);
            this.marker(model.marker);
        }

        public final String getReplicationTaskArn() {
            return this.replicationTaskArn;
        }

        @Override
        public final Builder replicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
            return this;
        }

        public final void setReplicationTaskArn(String replicationTaskArn) {
            this.replicationTaskArn = replicationTaskArn;
        }

        public final Collection<TableStatistics.Builder> getTableStatistics() {
            return this.tableStatistics != null ? (Collection)this.tableStatistics.stream().map(TableStatistics::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableStatistics(Collection<TableStatistics> tableStatistics) {
            this.tableStatistics = TableStatisticsListCopier.copy(tableStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableStatistics(TableStatistics ... tableStatistics) {
            this.tableStatistics(Arrays.asList(tableStatistics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableStatistics(Consumer<TableStatistics.Builder> ... tableStatistics) {
            this.tableStatistics(Stream.of(tableStatistics).map(c -> (TableStatistics)((TableStatistics.Builder)TableStatistics.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTableStatistics(Collection<TableStatistics.BuilderImpl> tableStatistics) {
            this.tableStatistics = TableStatisticsListCopier.copyFromBuilder(tableStatistics);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTableStatisticsResponse build() {
            return new DescribeTableStatisticsResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeTableStatisticsResponse> {
        public Builder replicationTaskArn(String var1);

        public Builder tableStatistics(Collection<TableStatistics> var1);

        public Builder tableStatistics(TableStatistics ... var1);

        public Builder tableStatistics(Consumer<TableStatistics.Builder> ... var1);

        public Builder marker(String var1);
    }
}

