/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResult;
import software.amazon.awssdk.services.databasemigration.model.ReplicationTaskAssessmentResultListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationTaskAssessmentResultsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationTaskAssessmentResultsResponse> {
    private final String marker;
    private final String bucketName;
    private final List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults;

    private DescribeReplicationTaskAssessmentResultsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.bucketName = builder.bucketName;
        this.replicationTaskAssessmentResults = builder.replicationTaskAssessmentResults;
    }

    public String marker() {
        return this.marker;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults() {
        return this.replicationTaskAssessmentResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationTaskAssessmentResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationTaskAssessmentResultsResponse)) {
            return false;
        }
        DescribeReplicationTaskAssessmentResultsResponse other = (DescribeReplicationTaskAssessmentResultsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.bucketName(), other.bucketName()) && Objects.equals(this.replicationTaskAssessmentResults(), other.replicationTaskAssessmentResults());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationTaskAssessmentResultsResponse").add("Marker", (Object)this.marker()).add("BucketName", (Object)this.bucketName()).add("ReplicationTaskAssessmentResults", this.replicationTaskAssessmentResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "BucketName": {
                return Optional.ofNullable(clazz.cast(this.bucketName()));
            }
            case "ReplicationTaskAssessmentResults": {
                return Optional.ofNullable(clazz.cast(this.replicationTaskAssessmentResults()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String marker;
        private String bucketName;
        private List<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationTaskAssessmentResultsResponse model) {
            super(model);
            this.marker(model.marker);
            this.bucketName(model.bucketName);
            this.replicationTaskAssessmentResults(model.replicationTaskAssessmentResults);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final Collection<ReplicationTaskAssessmentResult.Builder> getReplicationTaskAssessmentResults() {
            return this.replicationTaskAssessmentResults != null ? (Collection)this.replicationTaskAssessmentResults.stream().map(ReplicationTaskAssessmentResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationTaskAssessmentResults(Collection<ReplicationTaskAssessmentResult> replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults = ReplicationTaskAssessmentResultListCopier.copy(replicationTaskAssessmentResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentResults(ReplicationTaskAssessmentResult ... replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults(Arrays.asList(replicationTaskAssessmentResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTaskAssessmentResults(Consumer<ReplicationTaskAssessmentResult.Builder> ... replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults(Stream.of(replicationTaskAssessmentResults).map(c -> (ReplicationTaskAssessmentResult)((ReplicationTaskAssessmentResult.Builder)ReplicationTaskAssessmentResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationTaskAssessmentResults(Collection<ReplicationTaskAssessmentResult.BuilderImpl> replicationTaskAssessmentResults) {
            this.replicationTaskAssessmentResults = ReplicationTaskAssessmentResultListCopier.copyFromBuilder(replicationTaskAssessmentResults);
        }

        @Override
        public DescribeReplicationTaskAssessmentResultsResponse build() {
            return new DescribeReplicationTaskAssessmentResultsResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeReplicationTaskAssessmentResultsResponse> {
        public Builder marker(String var1);

        public Builder bucketName(String var1);

        public Builder replicationTaskAssessmentResults(Collection<ReplicationTaskAssessmentResult> var1);

        public Builder replicationTaskAssessmentResults(ReplicationTaskAssessmentResult ... var1);

        public Builder replicationTaskAssessmentResults(Consumer<ReplicationTaskAssessmentResult.Builder> ... var1);
    }
}

