/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.databasemigration.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.databasemigration.model.DatabaseMigrationResponse;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLog;
import software.amazon.awssdk.services.databasemigration.model.ReplicationInstanceTaskLogsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReplicationInstanceTaskLogsResponse
extends DatabaseMigrationResponse
implements ToCopyableBuilder<Builder, DescribeReplicationInstanceTaskLogsResponse> {
    private final String replicationInstanceArn;
    private final List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs;
    private final String marker;

    private DescribeReplicationInstanceTaskLogsResponse(BuilderImpl builder) {
        super(builder);
        this.replicationInstanceArn = builder.replicationInstanceArn;
        this.replicationInstanceTaskLogs = builder.replicationInstanceTaskLogs;
        this.marker = builder.marker;
    }

    public String replicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs() {
        return this.replicationInstanceTaskLogs;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationInstanceTaskLogs());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationInstanceTaskLogsResponse)) {
            return false;
        }
        DescribeReplicationInstanceTaskLogsResponse other = (DescribeReplicationInstanceTaskLogsResponse)((Object)obj);
        return Objects.equals(this.replicationInstanceArn(), other.replicationInstanceArn()) && Objects.equals(this.replicationInstanceTaskLogs(), other.replicationInstanceTaskLogs()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeReplicationInstanceTaskLogsResponse").add("ReplicationInstanceArn", (Object)this.replicationInstanceArn()).add("ReplicationInstanceTaskLogs", this.replicationInstanceTaskLogs()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplicationInstanceArn": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceArn()));
            }
            case "ReplicationInstanceTaskLogs": {
                return Optional.ofNullable(clazz.cast(this.replicationInstanceTaskLogs()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends DatabaseMigrationResponse.BuilderImpl
    implements Builder {
        private String replicationInstanceArn;
        private List<ReplicationInstanceTaskLog> replicationInstanceTaskLogs = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReplicationInstanceTaskLogsResponse model) {
            super(model);
            this.replicationInstanceArn(model.replicationInstanceArn);
            this.replicationInstanceTaskLogs(model.replicationInstanceTaskLogs);
            this.marker(model.marker);
        }

        public final String getReplicationInstanceArn() {
            return this.replicationInstanceArn;
        }

        @Override
        public final Builder replicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
            return this;
        }

        public final void setReplicationInstanceArn(String replicationInstanceArn) {
            this.replicationInstanceArn = replicationInstanceArn;
        }

        public final Collection<ReplicationInstanceTaskLog.Builder> getReplicationInstanceTaskLogs() {
            return this.replicationInstanceTaskLogs != null ? (Collection)this.replicationInstanceTaskLogs.stream().map(ReplicationInstanceTaskLog::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder replicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog> replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs = ReplicationInstanceTaskLogsListCopier.copy(replicationInstanceTaskLogs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceTaskLogs(ReplicationInstanceTaskLog ... replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs(Arrays.asList(replicationInstanceTaskLogs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationInstanceTaskLogs(Consumer<ReplicationInstanceTaskLog.Builder> ... replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs(Stream.of(replicationInstanceTaskLogs).map(c -> (ReplicationInstanceTaskLog)((ReplicationInstanceTaskLog.Builder)ReplicationInstanceTaskLog.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReplicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog.BuilderImpl> replicationInstanceTaskLogs) {
            this.replicationInstanceTaskLogs = ReplicationInstanceTaskLogsListCopier.copyFromBuilder(replicationInstanceTaskLogs);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeReplicationInstanceTaskLogsResponse build() {
            return new DescribeReplicationInstanceTaskLogsResponse(this);
        }
    }

    public static interface Builder
    extends DatabaseMigrationResponse.Builder,
    CopyableBuilder<Builder, DescribeReplicationInstanceTaskLogsResponse> {
        public Builder replicationInstanceArn(String var1);

        public Builder replicationInstanceTaskLogs(Collection<ReplicationInstanceTaskLog> var1);

        public Builder replicationInstanceTaskLogs(ReplicationInstanceTaskLog ... var1);

        public Builder replicationInstanceTaskLogs(Consumer<ReplicationInstanceTaskLog.Builder> ... var1);

        public Builder marker(String var1);
    }
}

