/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderSummary;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendersResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, ListRecommendersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecommendersResponse.getter(ListRecommendersResponse::nextToken)).setter(ListRecommendersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<RecommenderSummary>> RECOMMENDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recommenders").getter(ListRecommendersResponse.getter(ListRecommendersResponse::recommenders)).setter(ListRecommendersResponse.setter(Builder::recommenders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommenders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommenderSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RECOMMENDERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRecommendersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RecommenderSummary> recommenders;

    private ListRecommendersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.recommenders = builder.recommenders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRecommenders() {
        return this.recommenders != null && !(this.recommenders instanceof SdkAutoConstructList);
    }

    public final List<RecommenderSummary> recommenders() {
        return this.recommenders;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommenders() ? this.recommenders() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendersResponse)) {
            return false;
        }
        ListRecommendersResponse other = (ListRecommendersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRecommenders() == other.hasRecommenders() && Objects.equals(this.recommenders(), other.recommenders());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendersResponse").add("NextToken", (Object)this.nextToken()).add("Recommenders", this.hasRecommenders() ? this.recommenders() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Recommenders": {
                return Optional.ofNullable(clazz.cast(this.recommenders()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Recommenders", RECOMMENDERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendersResponse, T> g) {
        return obj -> g.apply((ListRecommendersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RecommenderSummary> recommenders = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.recommenders(model.recommenders);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RecommenderSummary.Builder> getRecommenders() {
            List<RecommenderSummary.Builder> result = RecommenderSummaryListCopier.copyToBuilder(this.recommenders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommenders(Collection<RecommenderSummary.BuilderImpl> recommenders) {
            this.recommenders = RecommenderSummaryListCopier.copyFromBuilder(recommenders);
        }

        @Override
        public final Builder recommenders(Collection<RecommenderSummary> recommenders) {
            this.recommenders = RecommenderSummaryListCopier.copy(recommenders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommenders(RecommenderSummary ... recommenders) {
            this.recommenders(Arrays.asList(recommenders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommenders(Consumer<RecommenderSummary.Builder> ... recommenders) {
            this.recommenders(Stream.of(recommenders).map(c -> (RecommenderSummary)((RecommenderSummary.Builder)RecommenderSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListRecommendersResponse build() {
            return new ListRecommendersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendersResponse> {
        public Builder nextToken(String var1);

        public Builder recommenders(Collection<RecommenderSummary> var1);

        public Builder recommenders(RecommenderSummary ... var1);

        public Builder recommenders(Consumer<RecommenderSummary.Builder> ... var1);
    }
}

