/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderConfig;
import software.amazon.awssdk.services.customerprofiles.model.RecommenderRecipeName;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateRecommenderRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, CreateRecommenderRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateRecommenderRequest.getter(CreateRecommenderRequest::domainName)).setter(CreateRecommenderRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> RECOMMENDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderName").getter(CreateRecommenderRequest.getter(CreateRecommenderRequest::recommenderName)).setter(CreateRecommenderRequest.setter(Builder::recommenderName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("RecommenderName").build()}).build();
    private static final SdkField<String> RECOMMENDER_RECIPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommenderRecipeName").getter(CreateRecommenderRequest.getter(CreateRecommenderRequest::recommenderRecipeNameAsString)).setter(CreateRecommenderRequest.setter(Builder::recommenderRecipeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderRecipeName").build()}).build();
    private static final SdkField<RecommenderConfig> RECOMMENDER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RecommenderConfig").getter(CreateRecommenderRequest.getter(CreateRecommenderRequest::recommenderConfig)).setter(CreateRecommenderRequest.setter(Builder::recommenderConfig)).constructor(RecommenderConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommenderConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateRecommenderRequest.getter(CreateRecommenderRequest::description)).setter(CreateRecommenderRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(CreateRecommenderRequest.getter(CreateRecommenderRequest::tags)).setter(CreateRecommenderRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, RECOMMENDER_NAME_FIELD, RECOMMENDER_RECIPE_NAME_FIELD, RECOMMENDER_CONFIG_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateRecommenderRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String recommenderName;
    private final String recommenderRecipeName;
    private final RecommenderConfig recommenderConfig;
    private final String description;
    private final Map<String, String> tags;

    private CreateRecommenderRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.recommenderName = builder.recommenderName;
        this.recommenderRecipeName = builder.recommenderRecipeName;
        this.recommenderConfig = builder.recommenderConfig;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String recommenderName() {
        return this.recommenderName;
    }

    public final RecommenderRecipeName recommenderRecipeName() {
        return RecommenderRecipeName.fromValue(this.recommenderRecipeName);
    }

    public final String recommenderRecipeNameAsString() {
        return this.recommenderRecipeName;
    }

    public final RecommenderConfig recommenderConfig() {
        return this.recommenderConfig;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderName());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderRecipeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommenderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRecommenderRequest)) {
            return false;
        }
        CreateRecommenderRequest other = (CreateRecommenderRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.recommenderName(), other.recommenderName()) && Objects.equals(this.recommenderRecipeNameAsString(), other.recommenderRecipeNameAsString()) && Objects.equals(this.recommenderConfig(), other.recommenderConfig()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateRecommenderRequest").add("DomainName", (Object)this.domainName()).add("RecommenderName", (Object)this.recommenderName()).add("RecommenderRecipeName", (Object)this.recommenderRecipeNameAsString()).add("RecommenderConfig", (Object)this.recommenderConfig()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "RecommenderName": {
                return Optional.ofNullable(clazz.cast(this.recommenderName()));
            }
            case "RecommenderRecipeName": {
                return Optional.ofNullable(clazz.cast(this.recommenderRecipeNameAsString()));
            }
            case "RecommenderConfig": {
                return Optional.ofNullable(clazz.cast(this.recommenderConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("RecommenderName", RECOMMENDER_NAME_FIELD);
        map.put("RecommenderRecipeName", RECOMMENDER_RECIPE_NAME_FIELD);
        map.put("RecommenderConfig", RECOMMENDER_CONFIG_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRecommenderRequest, T> g) {
        return obj -> g.apply((CreateRecommenderRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String recommenderName;
        private String recommenderRecipeName;
        private RecommenderConfig recommenderConfig;
        private String description;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRecommenderRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.recommenderName(model.recommenderName);
            this.recommenderRecipeName(model.recommenderRecipeName);
            this.recommenderConfig(model.recommenderConfig);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getRecommenderName() {
            return this.recommenderName;
        }

        public final void setRecommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
        }

        @Override
        public final Builder recommenderName(String recommenderName) {
            this.recommenderName = recommenderName;
            return this;
        }

        public final String getRecommenderRecipeName() {
            return this.recommenderRecipeName;
        }

        public final void setRecommenderRecipeName(String recommenderRecipeName) {
            this.recommenderRecipeName = recommenderRecipeName;
        }

        @Override
        public final Builder recommenderRecipeName(String recommenderRecipeName) {
            this.recommenderRecipeName = recommenderRecipeName;
            return this;
        }

        @Override
        public final Builder recommenderRecipeName(RecommenderRecipeName recommenderRecipeName) {
            this.recommenderRecipeName(recommenderRecipeName == null ? null : recommenderRecipeName.toString());
            return this;
        }

        public final RecommenderConfig.Builder getRecommenderConfig() {
            return this.recommenderConfig != null ? this.recommenderConfig.toBuilder() : null;
        }

        public final void setRecommenderConfig(RecommenderConfig.BuilderImpl recommenderConfig) {
            this.recommenderConfig = recommenderConfig != null ? recommenderConfig.build() : null;
        }

        @Override
        public final Builder recommenderConfig(RecommenderConfig recommenderConfig) {
            this.recommenderConfig = recommenderConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRecommenderRequest build() {
            return new CreateRecommenderRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateRecommenderRequest> {
        public Builder domainName(String var1);

        public Builder recommenderName(String var1);

        public Builder recommenderRecipeName(String var1);

        public Builder recommenderRecipeName(RecommenderRecipeName var1);

        public Builder recommenderConfig(RecommenderConfig var1);

        default public Builder recommenderConfig(Consumer<RecommenderConfig.Builder> recommenderConfig) {
            return this.recommenderConfig((RecommenderConfig)((RecommenderConfig.Builder)RecommenderConfig.builder().applyMutation(recommenderConfig)).build());
        }

        public Builder description(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

