/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCalculatedAttributeForProfileRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, GetCalculatedAttributeForProfileRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(GetCalculatedAttributeForProfileRequest.getter(GetCalculatedAttributeForProfileRequest::domainName)).setter(GetCalculatedAttributeForProfileRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileId").getter(GetCalculatedAttributeForProfileRequest.getter(GetCalculatedAttributeForProfileRequest::profileId)).setter(GetCalculatedAttributeForProfileRequest.setter(Builder::profileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProfileId").build()}).build();
    private static final SdkField<String> CALCULATED_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CalculatedAttributeName").getter(GetCalculatedAttributeForProfileRequest.getter(GetCalculatedAttributeForProfileRequest::calculatedAttributeName)).setter(GetCalculatedAttributeForProfileRequest.setter(Builder::calculatedAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("CalculatedAttributeName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, PROFILE_ID_FIELD, CALCULATED_ATTRIBUTE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DomainName", DOMAIN_NAME_FIELD);
            this.put("ProfileId", PROFILE_ID_FIELD);
            this.put("CalculatedAttributeName", CALCULATED_ATTRIBUTE_NAME_FIELD);
        }
    });
    private final String domainName;
    private final String profileId;
    private final String calculatedAttributeName;

    private GetCalculatedAttributeForProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.profileId = builder.profileId;
        this.calculatedAttributeName = builder.calculatedAttributeName;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String profileId() {
        return this.profileId;
    }

    public final String calculatedAttributeName() {
        return this.calculatedAttributeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedAttributeName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCalculatedAttributeForProfileRequest)) {
            return false;
        }
        GetCalculatedAttributeForProfileRequest other = (GetCalculatedAttributeForProfileRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.profileId(), other.profileId()) && Objects.equals(this.calculatedAttributeName(), other.calculatedAttributeName());
    }

    public final String toString() {
        return ToString.builder((String)"GetCalculatedAttributeForProfileRequest").add("DomainName", (Object)this.domainName()).add("ProfileId", (Object)this.profileId()).add("CalculatedAttributeName", (Object)this.calculatedAttributeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ProfileId": {
                return Optional.ofNullable(clazz.cast(this.profileId()));
            }
            case "CalculatedAttributeName": {
                return Optional.ofNullable(clazz.cast(this.calculatedAttributeName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetCalculatedAttributeForProfileRequest, T> g) {
        return obj -> g.apply((GetCalculatedAttributeForProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String profileId;
        private String calculatedAttributeName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCalculatedAttributeForProfileRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.profileId(model.profileId);
            this.calculatedAttributeName(model.calculatedAttributeName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getProfileId() {
            return this.profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getCalculatedAttributeName() {
            return this.calculatedAttributeName;
        }

        public final void setCalculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
        }

        @Override
        public final Builder calculatedAttributeName(String calculatedAttributeName) {
            this.calculatedAttributeName = calculatedAttributeName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCalculatedAttributeForProfileRequest build() {
            return new GetCalculatedAttributeForProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCalculatedAttributeForProfileRequest> {
        public Builder domainName(String var1);

        public Builder profileId(String var1);

        public Builder calculatedAttributeName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

