/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.Address;
import software.amazon.awssdk.services.customerprofiles.model.AttributesCopier;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.Gender;
import software.amazon.awssdk.services.customerprofiles.model.PartyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProfileRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, CreateProfileRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(CreateProfileRequest.getter(CreateProfileRequest::domainName)).setter(CreateProfileRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> ACCOUNT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountNumber").getter(CreateProfileRequest.getter(CreateProfileRequest::accountNumber)).setter(CreateProfileRequest.setter(Builder::accountNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountNumber").build()}).build();
    private static final SdkField<String> ADDITIONAL_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalInformation").getter(CreateProfileRequest.getter(CreateProfileRequest::additionalInformation)).setter(CreateProfileRequest.setter(Builder::additionalInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInformation").build()}).build();
    private static final SdkField<String> PARTY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartyType").getter(CreateProfileRequest.getter(CreateProfileRequest::partyTypeAsString)).setter(CreateProfileRequest.setter(Builder::partyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyType").build()}).build();
    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BusinessName").getter(CreateProfileRequest.getter(CreateProfileRequest::businessName)).setter(CreateProfileRequest.setter(Builder::businessName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessName").build()}).build();
    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FirstName").getter(CreateProfileRequest.getter(CreateProfileRequest::firstName)).setter(CreateProfileRequest.setter(Builder::firstName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()}).build();
    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MiddleName").getter(CreateProfileRequest.getter(CreateProfileRequest::middleName)).setter(CreateProfileRequest.setter(Builder::middleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()}).build();
    private static final SdkField<String> LAST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LastName").getter(CreateProfileRequest.getter(CreateProfileRequest::lastName)).setter(CreateProfileRequest.setter(Builder::lastName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()}).build();
    private static final SdkField<String> BIRTH_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BirthDate").getter(CreateProfileRequest.getter(CreateProfileRequest::birthDate)).setter(CreateProfileRequest.setter(Builder::birthDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BirthDate").build()}).build();
    private static final SdkField<String> GENDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Gender").getter(CreateProfileRequest.getter(CreateProfileRequest::genderAsString)).setter(CreateProfileRequest.setter(Builder::gender)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()}).build();
    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PhoneNumber").getter(CreateProfileRequest.getter(CreateProfileRequest::phoneNumber)).setter(CreateProfileRequest.setter(Builder::phoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()}).build();
    private static final SdkField<String> MOBILE_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MobilePhoneNumber").getter(CreateProfileRequest.getter(CreateProfileRequest::mobilePhoneNumber)).setter(CreateProfileRequest.setter(Builder::mobilePhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobilePhoneNumber").build()}).build();
    private static final SdkField<String> HOME_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomePhoneNumber").getter(CreateProfileRequest.getter(CreateProfileRequest::homePhoneNumber)).setter(CreateProfileRequest.setter(Builder::homePhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomePhoneNumber").build()}).build();
    private static final SdkField<String> BUSINESS_PHONE_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BusinessPhoneNumber").getter(CreateProfileRequest.getter(CreateProfileRequest::businessPhoneNumber)).setter(CreateProfileRequest.setter(Builder::businessPhoneNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessPhoneNumber").build()}).build();
    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmailAddress").getter(CreateProfileRequest.getter(CreateProfileRequest::emailAddress)).setter(CreateProfileRequest.setter(Builder::emailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()}).build();
    private static final SdkField<String> PERSONAL_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PersonalEmailAddress").getter(CreateProfileRequest.getter(CreateProfileRequest::personalEmailAddress)).setter(CreateProfileRequest.setter(Builder::personalEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalEmailAddress").build()}).build();
    private static final SdkField<String> BUSINESS_EMAIL_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BusinessEmailAddress").getter(CreateProfileRequest.getter(CreateProfileRequest::businessEmailAddress)).setter(CreateProfileRequest.setter(Builder::businessEmailAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessEmailAddress").build()}).build();
    private static final SdkField<Address> ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Address").getter(CreateProfileRequest.getter(CreateProfileRequest::address)).setter(CreateProfileRequest.setter(Builder::address)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()}).build();
    private static final SdkField<Address> SHIPPING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShippingAddress").getter(CreateProfileRequest.getter(CreateProfileRequest::shippingAddress)).setter(CreateProfileRequest.setter(Builder::shippingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()}).build();
    private static final SdkField<Address> MAILING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MailingAddress").getter(CreateProfileRequest.getter(CreateProfileRequest::mailingAddress)).setter(CreateProfileRequest.setter(Builder::mailingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailingAddress").build()}).build();
    private static final SdkField<Address> BILLING_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BillingAddress").getter(CreateProfileRequest.getter(CreateProfileRequest::billingAddress)).setter(CreateProfileRequest.setter(Builder::billingAddress)).constructor(Address::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingAddress").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(CreateProfileRequest.getter(CreateProfileRequest::attributes)).setter(CreateProfileRequest.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PARTY_TYPE_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PartyTypeString").getter(CreateProfileRequest.getter(CreateProfileRequest::partyTypeString)).setter(CreateProfileRequest.setter(Builder::partyTypeString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyTypeString").build()}).build();
    private static final SdkField<String> GENDER_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GenderString").getter(CreateProfileRequest.getter(CreateProfileRequest::genderString)).setter(CreateProfileRequest.setter(Builder::genderString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenderString").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ACCOUNT_NUMBER_FIELD, ADDITIONAL_INFORMATION_FIELD, PARTY_TYPE_FIELD, BUSINESS_NAME_FIELD, FIRST_NAME_FIELD, MIDDLE_NAME_FIELD, LAST_NAME_FIELD, BIRTH_DATE_FIELD, GENDER_FIELD, PHONE_NUMBER_FIELD, MOBILE_PHONE_NUMBER_FIELD, HOME_PHONE_NUMBER_FIELD, BUSINESS_PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD, PERSONAL_EMAIL_ADDRESS_FIELD, BUSINESS_EMAIL_ADDRESS_FIELD, ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD, MAILING_ADDRESS_FIELD, BILLING_ADDRESS_FIELD, ATTRIBUTES_FIELD, PARTY_TYPE_STRING_FIELD, GENDER_STRING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProfileRequest.memberNameToFieldInitializer();
    private final String domainName;
    private final String accountNumber;
    private final String additionalInformation;
    private final String partyType;
    private final String businessName;
    private final String firstName;
    private final String middleName;
    private final String lastName;
    private final String birthDate;
    private final String gender;
    private final String phoneNumber;
    private final String mobilePhoneNumber;
    private final String homePhoneNumber;
    private final String businessPhoneNumber;
    private final String emailAddress;
    private final String personalEmailAddress;
    private final String businessEmailAddress;
    private final Address address;
    private final Address shippingAddress;
    private final Address mailingAddress;
    private final Address billingAddress;
    private final Map<String, String> attributes;
    private final String partyTypeString;
    private final String genderString;

    private CreateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.accountNumber = builder.accountNumber;
        this.additionalInformation = builder.additionalInformation;
        this.partyType = builder.partyType;
        this.businessName = builder.businessName;
        this.firstName = builder.firstName;
        this.middleName = builder.middleName;
        this.lastName = builder.lastName;
        this.birthDate = builder.birthDate;
        this.gender = builder.gender;
        this.phoneNumber = builder.phoneNumber;
        this.mobilePhoneNumber = builder.mobilePhoneNumber;
        this.homePhoneNumber = builder.homePhoneNumber;
        this.businessPhoneNumber = builder.businessPhoneNumber;
        this.emailAddress = builder.emailAddress;
        this.personalEmailAddress = builder.personalEmailAddress;
        this.businessEmailAddress = builder.businessEmailAddress;
        this.address = builder.address;
        this.shippingAddress = builder.shippingAddress;
        this.mailingAddress = builder.mailingAddress;
        this.billingAddress = builder.billingAddress;
        this.attributes = builder.attributes;
        this.partyTypeString = builder.partyTypeString;
        this.genderString = builder.genderString;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String accountNumber() {
        return this.accountNumber;
    }

    public final String additionalInformation() {
        return this.additionalInformation;
    }

    public final PartyType partyType() {
        return PartyType.fromValue(this.partyType);
    }

    public final String partyTypeAsString() {
        return this.partyType;
    }

    public final String businessName() {
        return this.businessName;
    }

    public final String firstName() {
        return this.firstName;
    }

    public final String middleName() {
        return this.middleName;
    }

    public final String lastName() {
        return this.lastName;
    }

    public final String birthDate() {
        return this.birthDate;
    }

    public final Gender gender() {
        return Gender.fromValue(this.gender);
    }

    public final String genderAsString() {
        return this.gender;
    }

    public final String phoneNumber() {
        return this.phoneNumber;
    }

    public final String mobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    public final String homePhoneNumber() {
        return this.homePhoneNumber;
    }

    public final String businessPhoneNumber() {
        return this.businessPhoneNumber;
    }

    public final String emailAddress() {
        return this.emailAddress;
    }

    public final String personalEmailAddress() {
        return this.personalEmailAddress;
    }

    public final String businessEmailAddress() {
        return this.businessEmailAddress;
    }

    public final Address address() {
        return this.address;
    }

    public final Address shippingAddress() {
        return this.shippingAddress;
    }

    public final Address mailingAddress() {
        return this.mailingAddress;
    }

    public final Address billingAddress() {
        return this.billingAddress;
    }

    public final boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> attributes() {
        return this.attributes;
    }

    public final String partyTypeString() {
        return this.partyTypeString;
    }

    public final String genderString() {
        return this.genderString;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.partyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessName());
        hashCode = 31 * hashCode + Objects.hashCode(this.firstName());
        hashCode = 31 * hashCode + Objects.hashCode(this.middleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastName());
        hashCode = 31 * hashCode + Objects.hashCode(this.birthDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.genderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.mobilePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.homePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.businessEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.address());
        hashCode = 31 * hashCode + Objects.hashCode(this.shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttributes() ? this.attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.partyTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.genderString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProfileRequest)) {
            return false;
        }
        CreateProfileRequest other = (CreateProfileRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.accountNumber(), other.accountNumber()) && Objects.equals(this.additionalInformation(), other.additionalInformation()) && Objects.equals(this.partyTypeAsString(), other.partyTypeAsString()) && Objects.equals(this.businessName(), other.businessName()) && Objects.equals(this.firstName(), other.firstName()) && Objects.equals(this.middleName(), other.middleName()) && Objects.equals(this.lastName(), other.lastName()) && Objects.equals(this.birthDate(), other.birthDate()) && Objects.equals(this.genderAsString(), other.genderAsString()) && Objects.equals(this.phoneNumber(), other.phoneNumber()) && Objects.equals(this.mobilePhoneNumber(), other.mobilePhoneNumber()) && Objects.equals(this.homePhoneNumber(), other.homePhoneNumber()) && Objects.equals(this.businessPhoneNumber(), other.businessPhoneNumber()) && Objects.equals(this.emailAddress(), other.emailAddress()) && Objects.equals(this.personalEmailAddress(), other.personalEmailAddress()) && Objects.equals(this.businessEmailAddress(), other.businessEmailAddress()) && Objects.equals(this.address(), other.address()) && Objects.equals(this.shippingAddress(), other.shippingAddress()) && Objects.equals(this.mailingAddress(), other.mailingAddress()) && Objects.equals(this.billingAddress(), other.billingAddress()) && this.hasAttributes() == other.hasAttributes() && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.partyTypeString(), other.partyTypeString()) && Objects.equals(this.genderString(), other.genderString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProfileRequest").add("DomainName", (Object)this.domainName()).add("AccountNumber", (Object)(this.accountNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("AdditionalInformation", (Object)(this.additionalInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("PartyType", (Object)(this.partyTypeAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("BusinessName", (Object)(this.businessName() == null ? null : "*** Sensitive Data Redacted ***")).add("FirstName", (Object)(this.firstName() == null ? null : "*** Sensitive Data Redacted ***")).add("MiddleName", (Object)(this.middleName() == null ? null : "*** Sensitive Data Redacted ***")).add("LastName", (Object)(this.lastName() == null ? null : "*** Sensitive Data Redacted ***")).add("BirthDate", (Object)(this.birthDate() == null ? null : "*** Sensitive Data Redacted ***")).add("Gender", (Object)(this.genderAsString() == null ? null : "*** Sensitive Data Redacted ***")).add("PhoneNumber", (Object)(this.phoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("MobilePhoneNumber", (Object)(this.mobilePhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("HomePhoneNumber", (Object)(this.homePhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("BusinessPhoneNumber", (Object)(this.businessPhoneNumber() == null ? null : "*** Sensitive Data Redacted ***")).add("EmailAddress", (Object)(this.emailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("PersonalEmailAddress", (Object)(this.personalEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("BusinessEmailAddress", (Object)(this.businessEmailAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Address", (Object)(this.address() == null ? null : "*** Sensitive Data Redacted ***")).add("ShippingAddress", (Object)(this.shippingAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("MailingAddress", (Object)(this.mailingAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("BillingAddress", (Object)(this.billingAddress() == null ? null : "*** Sensitive Data Redacted ***")).add("Attributes", (Object)(this.attributes() == null ? null : "*** Sensitive Data Redacted ***")).add("PartyTypeString", (Object)(this.partyTypeString() == null ? null : "*** Sensitive Data Redacted ***")).add("GenderString", (Object)(this.genderString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "AccountNumber": {
                return Optional.ofNullable(clazz.cast(this.accountNumber()));
            }
            case "AdditionalInformation": {
                return Optional.ofNullable(clazz.cast(this.additionalInformation()));
            }
            case "PartyType": {
                return Optional.ofNullable(clazz.cast(this.partyTypeAsString()));
            }
            case "BusinessName": {
                return Optional.ofNullable(clazz.cast(this.businessName()));
            }
            case "FirstName": {
                return Optional.ofNullable(clazz.cast(this.firstName()));
            }
            case "MiddleName": {
                return Optional.ofNullable(clazz.cast(this.middleName()));
            }
            case "LastName": {
                return Optional.ofNullable(clazz.cast(this.lastName()));
            }
            case "BirthDate": {
                return Optional.ofNullable(clazz.cast(this.birthDate()));
            }
            case "Gender": {
                return Optional.ofNullable(clazz.cast(this.genderAsString()));
            }
            case "PhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.phoneNumber()));
            }
            case "MobilePhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.mobilePhoneNumber()));
            }
            case "HomePhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.homePhoneNumber()));
            }
            case "BusinessPhoneNumber": {
                return Optional.ofNullable(clazz.cast(this.businessPhoneNumber()));
            }
            case "EmailAddress": {
                return Optional.ofNullable(clazz.cast(this.emailAddress()));
            }
            case "PersonalEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.personalEmailAddress()));
            }
            case "BusinessEmailAddress": {
                return Optional.ofNullable(clazz.cast(this.businessEmailAddress()));
            }
            case "Address": {
                return Optional.ofNullable(clazz.cast(this.address()));
            }
            case "ShippingAddress": {
                return Optional.ofNullable(clazz.cast(this.shippingAddress()));
            }
            case "MailingAddress": {
                return Optional.ofNullable(clazz.cast(this.mailingAddress()));
            }
            case "BillingAddress": {
                return Optional.ofNullable(clazz.cast(this.billingAddress()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
            case "PartyTypeString": {
                return Optional.ofNullable(clazz.cast(this.partyTypeString()));
            }
            case "GenderString": {
                return Optional.ofNullable(clazz.cast(this.genderString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("AccountNumber", ACCOUNT_NUMBER_FIELD);
        map.put("AdditionalInformation", ADDITIONAL_INFORMATION_FIELD);
        map.put("PartyType", PARTY_TYPE_FIELD);
        map.put("BusinessName", BUSINESS_NAME_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("MiddleName", MIDDLE_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("BirthDate", BIRTH_DATE_FIELD);
        map.put("Gender", GENDER_FIELD);
        map.put("PhoneNumber", PHONE_NUMBER_FIELD);
        map.put("MobilePhoneNumber", MOBILE_PHONE_NUMBER_FIELD);
        map.put("HomePhoneNumber", HOME_PHONE_NUMBER_FIELD);
        map.put("BusinessPhoneNumber", BUSINESS_PHONE_NUMBER_FIELD);
        map.put("EmailAddress", EMAIL_ADDRESS_FIELD);
        map.put("PersonalEmailAddress", PERSONAL_EMAIL_ADDRESS_FIELD);
        map.put("BusinessEmailAddress", BUSINESS_EMAIL_ADDRESS_FIELD);
        map.put("Address", ADDRESS_FIELD);
        map.put("ShippingAddress", SHIPPING_ADDRESS_FIELD);
        map.put("MailingAddress", MAILING_ADDRESS_FIELD);
        map.put("BillingAddress", BILLING_ADDRESS_FIELD);
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("PartyTypeString", PARTY_TYPE_STRING_FIELD);
        map.put("GenderString", GENDER_STRING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProfileRequest, T> g) {
        return obj -> g.apply((CreateProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String accountNumber;
        private String additionalInformation;
        private String partyType;
        private String businessName;
        private String firstName;
        private String middleName;
        private String lastName;
        private String birthDate;
        private String gender;
        private String phoneNumber;
        private String mobilePhoneNumber;
        private String homePhoneNumber;
        private String businessPhoneNumber;
        private String emailAddress;
        private String personalEmailAddress;
        private String businessEmailAddress;
        private Address address;
        private Address shippingAddress;
        private Address mailingAddress;
        private Address billingAddress;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();
        private String partyTypeString;
        private String genderString;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProfileRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.accountNumber(model.accountNumber);
            this.additionalInformation(model.additionalInformation);
            this.partyType(model.partyType);
            this.businessName(model.businessName);
            this.firstName(model.firstName);
            this.middleName(model.middleName);
            this.lastName(model.lastName);
            this.birthDate(model.birthDate);
            this.gender(model.gender);
            this.phoneNumber(model.phoneNumber);
            this.mobilePhoneNumber(model.mobilePhoneNumber);
            this.homePhoneNumber(model.homePhoneNumber);
            this.businessPhoneNumber(model.businessPhoneNumber);
            this.emailAddress(model.emailAddress);
            this.personalEmailAddress(model.personalEmailAddress);
            this.businessEmailAddress(model.businessEmailAddress);
            this.address(model.address);
            this.shippingAddress(model.shippingAddress);
            this.mailingAddress(model.mailingAddress);
            this.billingAddress(model.billingAddress);
            this.attributes(model.attributes);
            this.partyTypeString(model.partyTypeString);
            this.genderString(model.genderString);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAccountNumber() {
            return this.accountNumber;
        }

        public final void setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        @Override
        public final Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public final String getAdditionalInformation() {
            return this.additionalInformation;
        }

        public final void setAdditionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
        }

        @Override
        public final Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final String getPartyType() {
            return this.partyType;
        }

        public final void setPartyType(String partyType) {
            this.partyType = partyType;
        }

        @Override
        public final Builder partyType(String partyType) {
            this.partyType = partyType;
            return this;
        }

        @Override
        public final Builder partyType(PartyType partyType) {
            this.partyType(partyType == null ? null : partyType.toString());
            return this;
        }

        public final String getBusinessName() {
            return this.businessName;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final String getFirstName() {
            return this.firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getMiddleName() {
            return this.middleName;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final String getLastName() {
            return this.lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getBirthDate() {
            return this.birthDate;
        }

        public final void setBirthDate(String birthDate) {
            this.birthDate = birthDate;
        }

        @Override
        public final Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public final String getGender() {
            return this.gender;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender(gender == null ? null : gender.toString());
            return this;
        }

        public final String getPhoneNumber() {
            return this.phoneNumber;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final String getMobilePhoneNumber() {
            return this.mobilePhoneNumber;
        }

        public final void setMobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
        }

        @Override
        public final Builder mobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this;
        }

        public final String getHomePhoneNumber() {
            return this.homePhoneNumber;
        }

        public final void setHomePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
        }

        @Override
        public final Builder homePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
            return this;
        }

        public final String getBusinessPhoneNumber() {
            return this.businessPhoneNumber;
        }

        public final void setBusinessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
        }

        @Override
        public final Builder businessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
            return this;
        }

        public final String getEmailAddress() {
            return this.emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getPersonalEmailAddress() {
            return this.personalEmailAddress;
        }

        public final void setPersonalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
        }

        @Override
        public final Builder personalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
            return this;
        }

        public final String getBusinessEmailAddress() {
            return this.businessEmailAddress;
        }

        public final void setBusinessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
        }

        @Override
        public final Builder businessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
            return this;
        }

        public final Address.Builder getAddress() {
            return this.address != null ? this.address.toBuilder() : null;
        }

        public final void setAddress(Address.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(Address address) {
            this.address = address;
            return this;
        }

        public final Address.Builder getShippingAddress() {
            return this.shippingAddress != null ? this.shippingAddress.toBuilder() : null;
        }

        public final void setShippingAddress(Address.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        @Override
        public final Builder shippingAddress(Address shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final Address.Builder getMailingAddress() {
            return this.mailingAddress != null ? this.mailingAddress.toBuilder() : null;
        }

        public final void setMailingAddress(Address.BuilderImpl mailingAddress) {
            this.mailingAddress = mailingAddress != null ? mailingAddress.build() : null;
        }

        @Override
        public final Builder mailingAddress(Address mailingAddress) {
            this.mailingAddress = mailingAddress;
            return this;
        }

        public final Address.Builder getBillingAddress() {
            return this.billingAddress != null ? this.billingAddress.toBuilder() : null;
        }

        public final void setBillingAddress(Address.BuilderImpl billingAddress) {
            this.billingAddress = billingAddress != null ? billingAddress.build() : null;
        }

        @Override
        public final Builder billingAddress(Address billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (this.attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final String getPartyTypeString() {
            return this.partyTypeString;
        }

        public final void setPartyTypeString(String partyTypeString) {
            this.partyTypeString = partyTypeString;
        }

        @Override
        public final Builder partyTypeString(String partyTypeString) {
            this.partyTypeString = partyTypeString;
            return this;
        }

        public final String getGenderString() {
            return this.genderString;
        }

        public final void setGenderString(String genderString) {
            this.genderString = genderString;
        }

        @Override
        public final Builder genderString(String genderString) {
            this.genderString = genderString;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProfileRequest build() {
            return new CreateProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProfileRequest> {
        public Builder domainName(String var1);

        public Builder accountNumber(String var1);

        public Builder additionalInformation(String var1);

        public Builder partyType(String var1);

        public Builder partyType(PartyType var1);

        public Builder businessName(String var1);

        public Builder firstName(String var1);

        public Builder middleName(String var1);

        public Builder lastName(String var1);

        public Builder birthDate(String var1);

        public Builder gender(String var1);

        public Builder gender(Gender var1);

        public Builder phoneNumber(String var1);

        public Builder mobilePhoneNumber(String var1);

        public Builder homePhoneNumber(String var1);

        public Builder businessPhoneNumber(String var1);

        public Builder emailAddress(String var1);

        public Builder personalEmailAddress(String var1);

        public Builder businessEmailAddress(String var1);

        public Builder address(Address var1);

        default public Builder address(Consumer<Address.Builder> address) {
            return this.address((Address)((Address.Builder)Address.builder().applyMutation(address)).build());
        }

        public Builder shippingAddress(Address var1);

        default public Builder shippingAddress(Consumer<Address.Builder> shippingAddress) {
            return this.shippingAddress((Address)((Address.Builder)Address.builder().applyMutation(shippingAddress)).build());
        }

        public Builder mailingAddress(Address var1);

        default public Builder mailingAddress(Consumer<Address.Builder> mailingAddress) {
            return this.mailingAddress((Address)((Address.Builder)Address.builder().applyMutation(mailingAddress)).build());
        }

        public Builder billingAddress(Address var1);

        default public Builder billingAddress(Consumer<Address.Builder> billingAddress) {
            return this.billingAddress((Address)((Address.Builder)Address.builder().applyMutation(billingAddress)).build());
        }

        public Builder attributes(Map<String, String> var1);

        public Builder partyTypeString(String var1);

        public Builder genderString(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

