/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.IncrementalPullConfig;
import software.amazon.awssdk.services.customerprofiles.model.SourceConnectorProperties;
import software.amazon.awssdk.services.customerprofiles.model.SourceConnectorType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceFlowConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceFlowConfig> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorProfileName").getter(SourceFlowConfig.getter(SourceFlowConfig::connectorProfileName)).setter(SourceFlowConfig.setter(Builder::connectorProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorProfileName").build()}).build();
    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectorType").getter(SourceFlowConfig.getter(SourceFlowConfig::connectorTypeAsString)).setter(SourceFlowConfig.setter(Builder::connectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorType").build()}).build();
    private static final SdkField<IncrementalPullConfig> INCREMENTAL_PULL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IncrementalPullConfig").getter(SourceFlowConfig.getter(SourceFlowConfig::incrementalPullConfig)).setter(SourceFlowConfig.setter(Builder::incrementalPullConfig)).constructor(IncrementalPullConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncrementalPullConfig").build()}).build();
    private static final SdkField<SourceConnectorProperties> SOURCE_CONNECTOR_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceConnectorProperties").getter(SourceFlowConfig.getter(SourceFlowConfig::sourceConnectorProperties)).setter(SourceFlowConfig.setter(Builder::sourceConnectorProperties)).constructor(SourceConnectorProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConnectorProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD, CONNECTOR_TYPE_FIELD, INCREMENTAL_PULL_CONFIG_FIELD, SOURCE_CONNECTOR_PROPERTIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String connectorProfileName;
    private final String connectorType;
    private final IncrementalPullConfig incrementalPullConfig;
    private final SourceConnectorProperties sourceConnectorProperties;

    private SourceFlowConfig(BuilderImpl builder) {
        this.connectorProfileName = builder.connectorProfileName;
        this.connectorType = builder.connectorType;
        this.incrementalPullConfig = builder.incrementalPullConfig;
        this.sourceConnectorProperties = builder.sourceConnectorProperties;
    }

    public final String connectorProfileName() {
        return this.connectorProfileName;
    }

    public final SourceConnectorType connectorType() {
        return SourceConnectorType.fromValue(this.connectorType);
    }

    public final String connectorTypeAsString() {
        return this.connectorType;
    }

    public final IncrementalPullConfig incrementalPullConfig() {
        return this.incrementalPullConfig;
    }

    public final SourceConnectorProperties sourceConnectorProperties() {
        return this.sourceConnectorProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.incrementalPullConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceConnectorProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFlowConfig)) {
            return false;
        }
        SourceFlowConfig other = (SourceFlowConfig)obj;
        return Objects.equals(this.connectorProfileName(), other.connectorProfileName()) && Objects.equals(this.connectorTypeAsString(), other.connectorTypeAsString()) && Objects.equals(this.incrementalPullConfig(), other.incrementalPullConfig()) && Objects.equals(this.sourceConnectorProperties(), other.sourceConnectorProperties());
    }

    public final String toString() {
        return ToString.builder((String)"SourceFlowConfig").add("ConnectorProfileName", (Object)this.connectorProfileName()).add("ConnectorType", (Object)this.connectorTypeAsString()).add("IncrementalPullConfig", (Object)this.incrementalPullConfig()).add("SourceConnectorProperties", (Object)this.sourceConnectorProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConnectorProfileName": {
                return Optional.ofNullable(clazz.cast(this.connectorProfileName()));
            }
            case "ConnectorType": {
                return Optional.ofNullable(clazz.cast(this.connectorTypeAsString()));
            }
            case "IncrementalPullConfig": {
                return Optional.ofNullable(clazz.cast(this.incrementalPullConfig()));
            }
            case "SourceConnectorProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceConnectorProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceFlowConfig, T> g) {
        return obj -> g.apply((SourceFlowConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorProfileName;
        private String connectorType;
        private IncrementalPullConfig incrementalPullConfig;
        private SourceConnectorProperties sourceConnectorProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFlowConfig model) {
            this.connectorProfileName(model.connectorProfileName);
            this.connectorType(model.connectorType);
            this.incrementalPullConfig(model.incrementalPullConfig);
            this.sourceConnectorProperties(model.sourceConnectorProperties);
        }

        public final String getConnectorProfileName() {
            return this.connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getConnectorType() {
            return this.connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        public final Builder connectorType(SourceConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final IncrementalPullConfig.Builder getIncrementalPullConfig() {
            return this.incrementalPullConfig != null ? this.incrementalPullConfig.toBuilder() : null;
        }

        public final void setIncrementalPullConfig(IncrementalPullConfig.BuilderImpl incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig != null ? incrementalPullConfig.build() : null;
        }

        @Override
        public final Builder incrementalPullConfig(IncrementalPullConfig incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig;
            return this;
        }

        public final SourceConnectorProperties.Builder getSourceConnectorProperties() {
            return this.sourceConnectorProperties != null ? this.sourceConnectorProperties.toBuilder() : null;
        }

        public final void setSourceConnectorProperties(SourceConnectorProperties.BuilderImpl sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties != null ? sourceConnectorProperties.build() : null;
        }

        @Override
        public final Builder sourceConnectorProperties(SourceConnectorProperties sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties;
            return this;
        }

        public SourceFlowConfig build() {
            return new SourceFlowConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceFlowConfig> {
        public Builder connectorProfileName(String var1);

        public Builder connectorType(String var1);

        public Builder connectorType(SourceConnectorType var1);

        public Builder incrementalPullConfig(IncrementalPullConfig var1);

        default public Builder incrementalPullConfig(Consumer<IncrementalPullConfig.Builder> incrementalPullConfig) {
            return this.incrementalPullConfig((IncrementalPullConfig)((IncrementalPullConfig.Builder)IncrementalPullConfig.builder().applyMutation(incrementalPullConfig)).build());
        }

        public Builder sourceConnectorProperties(SourceConnectorProperties var1);

        default public Builder sourceConnectorProperties(Consumer<SourceConnectorProperties.Builder> sourceConnectorProperties) {
            return this.sourceConnectorProperties((SourceConnectorProperties)((SourceConnectorProperties.Builder)SourceConnectorProperties.builder().applyMutation(sourceConnectorProperties)).build());
        }
    }
}

