/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsDbInstanceStorageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsDbInstanceStorageConfiguration> {
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(RdsDbInstanceStorageConfiguration.getter(RdsDbInstanceStorageConfiguration::storageType)).setter(RdsDbInstanceStorageConfiguration.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<Double> ALLOCATED_STORAGE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("allocatedStorageInGb").getter(RdsDbInstanceStorageConfiguration.getter(RdsDbInstanceStorageConfiguration::allocatedStorageInGb)).setter(RdsDbInstanceStorageConfiguration.setter(Builder::allocatedStorageInGb)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allocatedStorageInGb").build()}).build();
    private static final SdkField<Double> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("iops").getter(RdsDbInstanceStorageConfiguration.getter(RdsDbInstanceStorageConfiguration::iops)).setter(RdsDbInstanceStorageConfiguration.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()}).build();
    private static final SdkField<Double> STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("storageThroughput").getter(RdsDbInstanceStorageConfiguration.getter(RdsDbInstanceStorageConfiguration::storageThroughput)).setter(RdsDbInstanceStorageConfiguration.setter(Builder::storageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageThroughput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_TYPE_FIELD, ALLOCATED_STORAGE_IN_GB_FIELD, IOPS_FIELD, STORAGE_THROUGHPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RdsDbInstanceStorageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String storageType;
    private final Double allocatedStorageInGb;
    private final Double iops;
    private final Double storageThroughput;

    private RdsDbInstanceStorageConfiguration(BuilderImpl builder) {
        this.storageType = builder.storageType;
        this.allocatedStorageInGb = builder.allocatedStorageInGb;
        this.iops = builder.iops;
        this.storageThroughput = builder.storageThroughput;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Double allocatedStorageInGb() {
        return this.allocatedStorageInGb;
    }

    public final Double iops() {
        return this.iops;
    }

    public final Double storageThroughput() {
        return this.storageThroughput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorageInGb());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageThroughput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsDbInstanceStorageConfiguration)) {
            return false;
        }
        RdsDbInstanceStorageConfiguration other = (RdsDbInstanceStorageConfiguration)obj;
        return Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.allocatedStorageInGb(), other.allocatedStorageInGb()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.storageThroughput(), other.storageThroughput());
    }

    public final String toString() {
        return ToString.builder((String)"RdsDbInstanceStorageConfiguration").add("StorageType", (Object)this.storageType()).add("AllocatedStorageInGb", (Object)this.allocatedStorageInGb()).add("Iops", (Object)this.iops()).add("StorageThroughput", (Object)this.storageThroughput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "allocatedStorageInGb": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorageInGb()));
            }
            case "iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "storageThroughput": {
                return Optional.ofNullable(clazz.cast(this.storageThroughput()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("allocatedStorageInGb", ALLOCATED_STORAGE_IN_GB_FIELD);
        map.put("iops", IOPS_FIELD);
        map.put("storageThroughput", STORAGE_THROUGHPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsDbInstanceStorageConfiguration, T> g) {
        return obj -> g.apply((RdsDbInstanceStorageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageType;
        private Double allocatedStorageInGb;
        private Double iops;
        private Double storageThroughput;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsDbInstanceStorageConfiguration model) {
            this.storageType(model.storageType);
            this.allocatedStorageInGb(model.allocatedStorageInGb);
            this.iops(model.iops);
            this.storageThroughput(model.storageThroughput);
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Double getAllocatedStorageInGb() {
            return this.allocatedStorageInGb;
        }

        public final void setAllocatedStorageInGb(Double allocatedStorageInGb) {
            this.allocatedStorageInGb = allocatedStorageInGb;
        }

        @Override
        public final Builder allocatedStorageInGb(Double allocatedStorageInGb) {
            this.allocatedStorageInGb = allocatedStorageInGb;
            return this;
        }

        public final Double getIops() {
            return this.iops;
        }

        public final void setIops(Double iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Double iops) {
            this.iops = iops;
            return this;
        }

        public final Double getStorageThroughput() {
            return this.storageThroughput;
        }

        public final void setStorageThroughput(Double storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Double storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public RdsDbInstanceStorageConfiguration build() {
            return new RdsDbInstanceStorageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsDbInstanceStorageConfiguration> {
        public Builder storageType(String var1);

        public Builder allocatedStorageInGb(Double var1);

        public Builder iops(Double var1);

        public Builder storageThroughput(Double var1);
    }
}

