/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costoptimizationhub.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costoptimizationhub.model.Source;
import software.amazon.awssdk.services.costoptimizationhub.model.Tag;
import software.amazon.awssdk.services.costoptimizationhub.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Recommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Recommendation> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(Recommendation.getter(Recommendation::accountId)).setter(Recommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(Recommendation.getter(Recommendation::actionType)).setter(Recommendation.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currencyCode").getter(Recommendation.getter(Recommendation::currencyCode)).setter(Recommendation.setter(Builder::currencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()}).build();
    private static final SdkField<String> CURRENT_RESOURCE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentResourceSummary").getter(Recommendation.getter(Recommendation::currentResourceSummary)).setter(Recommendation.setter(Builder::currentResourceSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentResourceSummary").build()}).build();
    private static final SdkField<String> CURRENT_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentResourceType").getter(Recommendation.getter(Recommendation::currentResourceType)).setter(Recommendation.setter(Builder::currentResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentResourceType").build()}).build();
    private static final SdkField<Double> ESTIMATED_MONTHLY_COST_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedMonthlyCost").getter(Recommendation.getter(Recommendation::estimatedMonthlyCost)).setter(Recommendation.setter(Builder::estimatedMonthlyCost)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlyCost").build()}).build();
    private static final SdkField<Double> ESTIMATED_MONTHLY_SAVINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedMonthlySavings").getter(Recommendation.getter(Recommendation::estimatedMonthlySavings)).setter(Recommendation.setter(Builder::estimatedMonthlySavings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedMonthlySavings").build()}).build();
    private static final SdkField<Double> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("estimatedSavingsPercentage").getter(Recommendation.getter(Recommendation::estimatedSavingsPercentage)).setter(Recommendation.setter(Builder::estimatedSavingsPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedSavingsPercentage").build()}).build();
    private static final SdkField<String> IMPLEMENTATION_EFFORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("implementationEffort").getter(Recommendation.getter(Recommendation::implementationEffort)).setter(Recommendation.setter(Builder::implementationEffort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("implementationEffort").build()}).build();
    private static final SdkField<Instant> LAST_REFRESH_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRefreshTimestamp").getter(Recommendation.getter(Recommendation::lastRefreshTimestamp)).setter(Recommendation.setter(Builder::lastRefreshTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRefreshTimestamp").build()}).build();
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationId").getter(Recommendation.getter(Recommendation::recommendationId)).setter(Recommendation.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationId").build()}).build();
    private static final SdkField<Integer> RECOMMENDATION_LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("recommendationLookbackPeriodInDays").getter(Recommendation.getter(Recommendation::recommendationLookbackPeriodInDays)).setter(Recommendation.setter(Builder::recommendationLookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationLookbackPeriodInDays").build()}).build();
    private static final SdkField<String> RECOMMENDED_RESOURCE_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedResourceSummary").getter(Recommendation.getter(Recommendation::recommendedResourceSummary)).setter(Recommendation.setter(Builder::recommendedResourceSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedResourceSummary").build()}).build();
    private static final SdkField<String> RECOMMENDED_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendedResourceType").getter(Recommendation.getter(Recommendation::recommendedResourceType)).setter(Recommendation.setter(Builder::recommendedResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedResourceType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Recommendation.getter(Recommendation::region)).setter(Recommendation.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(Recommendation.getter(Recommendation::resourceArn)).setter(Recommendation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceId").getter(Recommendation.getter(Recommendation::resourceId)).setter(Recommendation.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()}).build();
    private static final SdkField<Boolean> RESTART_NEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("restartNeeded").getter(Recommendation.getter(Recommendation::restartNeeded)).setter(Recommendation.setter(Builder::restartNeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("restartNeeded").build()}).build();
    private static final SdkField<Boolean> ROLLBACK_POSSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("rollbackPossible").getter(Recommendation.getter(Recommendation::rollbackPossible)).setter(Recommendation.setter(Builder::rollbackPossible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rollbackPossible").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source").getter(Recommendation.getter(Recommendation::sourceAsString)).setter(Recommendation.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(Recommendation.getter(Recommendation::tags)).setter(Recommendation.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, ACTION_TYPE_FIELD, CURRENCY_CODE_FIELD, CURRENT_RESOURCE_SUMMARY_FIELD, CURRENT_RESOURCE_TYPE_FIELD, ESTIMATED_MONTHLY_COST_FIELD, ESTIMATED_MONTHLY_SAVINGS_FIELD, ESTIMATED_SAVINGS_PERCENTAGE_FIELD, IMPLEMENTATION_EFFORT_FIELD, LAST_REFRESH_TIMESTAMP_FIELD, RECOMMENDATION_ID_FIELD, RECOMMENDATION_LOOKBACK_PERIOD_IN_DAYS_FIELD, RECOMMENDED_RESOURCE_SUMMARY_FIELD, RECOMMENDED_RESOURCE_TYPE_FIELD, REGION_FIELD, RESOURCE_ARN_FIELD, RESOURCE_ID_FIELD, RESTART_NEEDED_FIELD, ROLLBACK_POSSIBLE_FIELD, SOURCE_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final String actionType;
    private final String currencyCode;
    private final String currentResourceSummary;
    private final String currentResourceType;
    private final Double estimatedMonthlyCost;
    private final Double estimatedMonthlySavings;
    private final Double estimatedSavingsPercentage;
    private final String implementationEffort;
    private final Instant lastRefreshTimestamp;
    private final String recommendationId;
    private final Integer recommendationLookbackPeriodInDays;
    private final String recommendedResourceSummary;
    private final String recommendedResourceType;
    private final String region;
    private final String resourceArn;
    private final String resourceId;
    private final Boolean restartNeeded;
    private final Boolean rollbackPossible;
    private final String source;
    private final List<Tag> tags;

    private Recommendation(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.actionType = builder.actionType;
        this.currencyCode = builder.currencyCode;
        this.currentResourceSummary = builder.currentResourceSummary;
        this.currentResourceType = builder.currentResourceType;
        this.estimatedMonthlyCost = builder.estimatedMonthlyCost;
        this.estimatedMonthlySavings = builder.estimatedMonthlySavings;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.implementationEffort = builder.implementationEffort;
        this.lastRefreshTimestamp = builder.lastRefreshTimestamp;
        this.recommendationId = builder.recommendationId;
        this.recommendationLookbackPeriodInDays = builder.recommendationLookbackPeriodInDays;
        this.recommendedResourceSummary = builder.recommendedResourceSummary;
        this.recommendedResourceType = builder.recommendedResourceType;
        this.region = builder.region;
        this.resourceArn = builder.resourceArn;
        this.resourceId = builder.resourceId;
        this.restartNeeded = builder.restartNeeded;
        this.rollbackPossible = builder.rollbackPossible;
        this.source = builder.source;
        this.tags = builder.tags;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String actionType() {
        return this.actionType;
    }

    public final String currencyCode() {
        return this.currencyCode;
    }

    public final String currentResourceSummary() {
        return this.currentResourceSummary;
    }

    public final String currentResourceType() {
        return this.currentResourceType;
    }

    public final Double estimatedMonthlyCost() {
        return this.estimatedMonthlyCost;
    }

    public final Double estimatedMonthlySavings() {
        return this.estimatedMonthlySavings;
    }

    public final Double estimatedSavingsPercentage() {
        return this.estimatedSavingsPercentage;
    }

    public final String implementationEffort() {
        return this.implementationEffort;
    }

    public final Instant lastRefreshTimestamp() {
        return this.lastRefreshTimestamp;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final Integer recommendationLookbackPeriodInDays() {
        return this.recommendationLookbackPeriodInDays;
    }

    public final String recommendedResourceSummary() {
        return this.recommendedResourceSummary;
    }

    public final String recommendedResourceType() {
        return this.recommendedResourceType;
    }

    public final String region() {
        return this.region;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    public final Boolean restartNeeded() {
        return this.restartNeeded;
    }

    public final Boolean rollbackPossible() {
        return this.rollbackPossible;
    }

    public final Source source() {
        return Source.fromValue(this.source);
    }

    public final String sourceAsString() {
        return this.source;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentResourceSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlyCost());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedMonthlySavings());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.implementationEffort());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRefreshTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationLookbackPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedResourceSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendedResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.restartNeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.rollbackPossible());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recommendation)) {
            return false;
        }
        Recommendation other = (Recommendation)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.actionType(), other.actionType()) && Objects.equals(this.currencyCode(), other.currencyCode()) && Objects.equals(this.currentResourceSummary(), other.currentResourceSummary()) && Objects.equals(this.currentResourceType(), other.currentResourceType()) && Objects.equals(this.estimatedMonthlyCost(), other.estimatedMonthlyCost()) && Objects.equals(this.estimatedMonthlySavings(), other.estimatedMonthlySavings()) && Objects.equals(this.estimatedSavingsPercentage(), other.estimatedSavingsPercentage()) && Objects.equals(this.implementationEffort(), other.implementationEffort()) && Objects.equals(this.lastRefreshTimestamp(), other.lastRefreshTimestamp()) && Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.recommendationLookbackPeriodInDays(), other.recommendationLookbackPeriodInDays()) && Objects.equals(this.recommendedResourceSummary(), other.recommendedResourceSummary()) && Objects.equals(this.recommendedResourceType(), other.recommendedResourceType()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceId(), other.resourceId()) && Objects.equals(this.restartNeeded(), other.restartNeeded()) && Objects.equals(this.rollbackPossible(), other.rollbackPossible()) && Objects.equals(this.sourceAsString(), other.sourceAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Recommendation").add("AccountId", (Object)this.accountId()).add("ActionType", (Object)this.actionType()).add("CurrencyCode", (Object)this.currencyCode()).add("CurrentResourceSummary", (Object)this.currentResourceSummary()).add("CurrentResourceType", (Object)this.currentResourceType()).add("EstimatedMonthlyCost", (Object)this.estimatedMonthlyCost()).add("EstimatedMonthlySavings", (Object)this.estimatedMonthlySavings()).add("EstimatedSavingsPercentage", (Object)this.estimatedSavingsPercentage()).add("ImplementationEffort", (Object)this.implementationEffort()).add("LastRefreshTimestamp", (Object)this.lastRefreshTimestamp()).add("RecommendationId", (Object)this.recommendationId()).add("RecommendationLookbackPeriodInDays", (Object)this.recommendationLookbackPeriodInDays()).add("RecommendedResourceSummary", (Object)this.recommendedResourceSummary()).add("RecommendedResourceType", (Object)this.recommendedResourceType()).add("Region", (Object)this.region()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceId", (Object)this.resourceId()).add("RestartNeeded", (Object)this.restartNeeded()).add("RollbackPossible", (Object)this.rollbackPossible()).add("Source", (Object)this.sourceAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionType()));
            }
            case "currencyCode": {
                return Optional.ofNullable(clazz.cast(this.currencyCode()));
            }
            case "currentResourceSummary": {
                return Optional.ofNullable(clazz.cast(this.currentResourceSummary()));
            }
            case "currentResourceType": {
                return Optional.ofNullable(clazz.cast(this.currentResourceType()));
            }
            case "estimatedMonthlyCost": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlyCost()));
            }
            case "estimatedMonthlySavings": {
                return Optional.ofNullable(clazz.cast(this.estimatedMonthlySavings()));
            }
            case "estimatedSavingsPercentage": {
                return Optional.ofNullable(clazz.cast(this.estimatedSavingsPercentage()));
            }
            case "implementationEffort": {
                return Optional.ofNullable(clazz.cast(this.implementationEffort()));
            }
            case "lastRefreshTimestamp": {
                return Optional.ofNullable(clazz.cast(this.lastRefreshTimestamp()));
            }
            case "recommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "recommendationLookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.recommendationLookbackPeriodInDays()));
            }
            case "recommendedResourceSummary": {
                return Optional.ofNullable(clazz.cast(this.recommendedResourceSummary()));
            }
            case "recommendedResourceType": {
                return Optional.ofNullable(clazz.cast(this.recommendedResourceType()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "resourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
            case "restartNeeded": {
                return Optional.ofNullable(clazz.cast(this.restartNeeded()));
            }
            case "rollbackPossible": {
                return Optional.ofNullable(clazz.cast(this.rollbackPossible()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.sourceAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recommendation, T> g) {
        return obj -> g.apply((Recommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private String actionType;
        private String currencyCode;
        private String currentResourceSummary;
        private String currentResourceType;
        private Double estimatedMonthlyCost;
        private Double estimatedMonthlySavings;
        private Double estimatedSavingsPercentage;
        private String implementationEffort;
        private Instant lastRefreshTimestamp;
        private String recommendationId;
        private Integer recommendationLookbackPeriodInDays;
        private String recommendedResourceSummary;
        private String recommendedResourceType;
        private String region;
        private String resourceArn;
        private String resourceId;
        private Boolean restartNeeded;
        private Boolean rollbackPossible;
        private String source;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recommendation model) {
            this.accountId(model.accountId);
            this.actionType(model.actionType);
            this.currencyCode(model.currencyCode);
            this.currentResourceSummary(model.currentResourceSummary);
            this.currentResourceType(model.currentResourceType);
            this.estimatedMonthlyCost(model.estimatedMonthlyCost);
            this.estimatedMonthlySavings(model.estimatedMonthlySavings);
            this.estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            this.implementationEffort(model.implementationEffort);
            this.lastRefreshTimestamp(model.lastRefreshTimestamp);
            this.recommendationId(model.recommendationId);
            this.recommendationLookbackPeriodInDays(model.recommendationLookbackPeriodInDays);
            this.recommendedResourceSummary(model.recommendedResourceSummary);
            this.recommendedResourceType(model.recommendedResourceType);
            this.region(model.region);
            this.resourceArn(model.resourceArn);
            this.resourceId(model.resourceId);
            this.restartNeeded(model.restartNeeded);
            this.rollbackPossible(model.rollbackPossible);
            this.source(model.source);
            this.tags(model.tags);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final String getCurrencyCode() {
            return this.currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getCurrentResourceSummary() {
            return this.currentResourceSummary;
        }

        public final void setCurrentResourceSummary(String currentResourceSummary) {
            this.currentResourceSummary = currentResourceSummary;
        }

        @Override
        public final Builder currentResourceSummary(String currentResourceSummary) {
            this.currentResourceSummary = currentResourceSummary;
            return this;
        }

        public final String getCurrentResourceType() {
            return this.currentResourceType;
        }

        public final void setCurrentResourceType(String currentResourceType) {
            this.currentResourceType = currentResourceType;
        }

        @Override
        public final Builder currentResourceType(String currentResourceType) {
            this.currentResourceType = currentResourceType;
            return this;
        }

        public final Double getEstimatedMonthlyCost() {
            return this.estimatedMonthlyCost;
        }

        public final void setEstimatedMonthlyCost(Double estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
        }

        @Override
        public final Builder estimatedMonthlyCost(Double estimatedMonthlyCost) {
            this.estimatedMonthlyCost = estimatedMonthlyCost;
            return this;
        }

        public final Double getEstimatedMonthlySavings() {
            return this.estimatedMonthlySavings;
        }

        public final void setEstimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
        }

        @Override
        public final Builder estimatedMonthlySavings(Double estimatedMonthlySavings) {
            this.estimatedMonthlySavings = estimatedMonthlySavings;
            return this;
        }

        public final Double getEstimatedSavingsPercentage() {
            return this.estimatedSavingsPercentage;
        }

        public final void setEstimatedSavingsPercentage(Double estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(Double estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final String getImplementationEffort() {
            return this.implementationEffort;
        }

        public final void setImplementationEffort(String implementationEffort) {
            this.implementationEffort = implementationEffort;
        }

        @Override
        public final Builder implementationEffort(String implementationEffort) {
            this.implementationEffort = implementationEffort;
            return this;
        }

        public final Instant getLastRefreshTimestamp() {
            return this.lastRefreshTimestamp;
        }

        public final void setLastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
        }

        @Override
        public final Builder lastRefreshTimestamp(Instant lastRefreshTimestamp) {
            this.lastRefreshTimestamp = lastRefreshTimestamp;
            return this;
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final Integer getRecommendationLookbackPeriodInDays() {
            return this.recommendationLookbackPeriodInDays;
        }

        public final void setRecommendationLookbackPeriodInDays(Integer recommendationLookbackPeriodInDays) {
            this.recommendationLookbackPeriodInDays = recommendationLookbackPeriodInDays;
        }

        @Override
        public final Builder recommendationLookbackPeriodInDays(Integer recommendationLookbackPeriodInDays) {
            this.recommendationLookbackPeriodInDays = recommendationLookbackPeriodInDays;
            return this;
        }

        public final String getRecommendedResourceSummary() {
            return this.recommendedResourceSummary;
        }

        public final void setRecommendedResourceSummary(String recommendedResourceSummary) {
            this.recommendedResourceSummary = recommendedResourceSummary;
        }

        @Override
        public final Builder recommendedResourceSummary(String recommendedResourceSummary) {
            this.recommendedResourceSummary = recommendedResourceSummary;
            return this;
        }

        public final String getRecommendedResourceType() {
            return this.recommendedResourceType;
        }

        public final void setRecommendedResourceType(String recommendedResourceType) {
            this.recommendedResourceType = recommendedResourceType;
        }

        @Override
        public final Builder recommendedResourceType(String recommendedResourceType) {
            this.recommendedResourceType = recommendedResourceType;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final Boolean getRestartNeeded() {
            return this.restartNeeded;
        }

        public final void setRestartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
        }

        @Override
        public final Builder restartNeeded(Boolean restartNeeded) {
            this.restartNeeded = restartNeeded;
            return this;
        }

        public final Boolean getRollbackPossible() {
            return this.rollbackPossible;
        }

        public final void setRollbackPossible(Boolean rollbackPossible) {
            this.rollbackPossible = rollbackPossible;
        }

        @Override
        public final Builder rollbackPossible(Boolean rollbackPossible) {
            this.rollbackPossible = rollbackPossible;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(Source source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Recommendation build() {
            return new Recommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Recommendation> {
        public Builder accountId(String var1);

        public Builder actionType(String var1);

        public Builder currencyCode(String var1);

        public Builder currentResourceSummary(String var1);

        public Builder currentResourceType(String var1);

        public Builder estimatedMonthlyCost(Double var1);

        public Builder estimatedMonthlySavings(Double var1);

        public Builder estimatedSavingsPercentage(Double var1);

        public Builder implementationEffort(String var1);

        public Builder lastRefreshTimestamp(Instant var1);

        public Builder recommendationId(String var1);

        public Builder recommendationLookbackPeriodInDays(Integer var1);

        public Builder recommendedResourceSummary(String var1);

        public Builder recommendedResourceType(String var1);

        public Builder region(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceId(String var1);

        public Builder restartNeeded(Boolean var1);

        public Builder rollbackPossible(Boolean var1);

        public Builder source(String var1);

        public Builder source(Source var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

