/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.OfferingClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2Specification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2Specification> {
    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EC2Specification.getter(EC2Specification::offeringClassAsString)).setter(EC2Specification.setter(Builder::offeringClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFERING_CLASS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String offeringClass;

    private EC2Specification(BuilderImpl builder) {
        this.offeringClass = builder.offeringClass;
    }

    public OfferingClass offeringClass() {
        return OfferingClass.fromValue(this.offeringClass);
    }

    public String offeringClassAsString() {
        return this.offeringClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2Specification)) {
            return false;
        }
        EC2Specification other = (EC2Specification)obj;
        return Objects.equals(this.offeringClassAsString(), other.offeringClassAsString());
    }

    public String toString() {
        return ToString.builder((String)"EC2Specification").add("OfferingClass", (Object)this.offeringClassAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OfferingClass": {
                return Optional.ofNullable(clazz.cast(this.offeringClassAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2Specification, T> g) {
        return obj -> g.apply((EC2Specification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String offeringClass;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2Specification model) {
            this.offeringClass(model.offeringClass);
        }

        public final String getOfferingClassAsString() {
            return this.offeringClass;
        }

        @Override
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        public final Builder offeringClass(OfferingClass offeringClass) {
            this.offeringClass(offeringClass.toString());
            return this;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        public EC2Specification build() {
            return new EC2Specification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2Specification> {
        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClass var1);
    }
}

