/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.Coverage;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup;
import software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroupsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CoverageByTime
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CoverageByTime> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CoverageByTime.getter(CoverageByTime::timePeriod)).setter(CoverageByTime.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<List<ReservationCoverageGroup>> GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CoverageByTime.getter(CoverageByTime::groups)).setter(CoverageByTime.setter(Builder::groups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservationCoverageGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Coverage> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CoverageByTime.getter(CoverageByTime::total)).setter(CoverageByTime.setter(Builder::total)).constructor(Coverage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, GROUPS_FIELD, TOTAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final DateInterval timePeriod;
    private final List<ReservationCoverageGroup> groups;
    private final Coverage total;

    private CoverageByTime(BuilderImpl builder) {
        this.timePeriod = builder.timePeriod;
        this.groups = builder.groups;
        this.total = builder.total;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public List<ReservationCoverageGroup> groups() {
        return this.groups;
    }

    public Coverage total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.groups());
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageByTime)) {
            return false;
        }
        CoverageByTime other = (CoverageByTime)obj;
        return Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.groups(), other.groups()) && Objects.equals(this.total(), other.total());
    }

    public String toString() {
        return ToString.builder((String)"CoverageByTime").add("TimePeriod", (Object)this.timePeriod()).add("Groups", this.groups()).add("Total", (Object)this.total()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Groups": {
                return Optional.ofNullable(clazz.cast(this.groups()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageByTime, T> g) {
        return obj -> g.apply((CoverageByTime)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private List<ReservationCoverageGroup> groups = DefaultSdkAutoConstructList.getInstance();
        private Coverage total;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageByTime model) {
            this.timePeriod(model.timePeriod);
            this.groups(model.groups);
            this.total(model.total);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final Collection<ReservationCoverageGroup.Builder> getGroups() {
            return this.groups != null ? (Collection)this.groups.stream().map(ReservationCoverageGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder groups(Collection<ReservationCoverageGroup> groups) {
            this.groups = ReservationCoverageGroupsCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(ReservationCoverageGroup ... groups) {
            this.groups(Arrays.asList(groups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(Consumer<ReservationCoverageGroup.Builder> ... groups) {
            this.groups(Stream.of(groups).map(c -> (ReservationCoverageGroup)((ReservationCoverageGroup.Builder)ReservationCoverageGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGroups(Collection<ReservationCoverageGroup.BuilderImpl> groups) {
            this.groups = ReservationCoverageGroupsCopier.copyFromBuilder(groups);
        }

        public final Coverage.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(Coverage total) {
            this.total = total;
            return this;
        }

        public final void setTotal(Coverage.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public CoverageByTime build() {
            return new CoverageByTime(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CoverageByTime> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder groups(Collection<ReservationCoverageGroup> var1);

        public Builder groups(ReservationCoverageGroup ... var1);

        public Builder groups(Consumer<ReservationCoverageGroup.Builder> ... var1);

        public Builder total(Coverage var1);

        default public Builder total(Consumer<Coverage.Builder> total) {
            return this.total((Coverage)((Coverage.Builder)Coverage.builder().applyMutation(total)).build());
        }
    }
}

