/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCostAndUsageComparisonsResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetCostAndUsageComparisonsResponse.Builder, GetCostAndUsageComparisonsResponse> {
    private static final SdkField<List<CostAndUsageComparison>> COST_AND_USAGE_COMPARISONS_FIELD = SdkField
            .<List<CostAndUsageComparison>> builder(MarshallingType.LIST)
            .memberName("CostAndUsageComparisons")
            .getter(getter(GetCostAndUsageComparisonsResponse::costAndUsageComparisons))
            .setter(setter(Builder::costAndUsageComparisons))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostAndUsageComparisons").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostAndUsageComparison> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostAndUsageComparison::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, ComparisonMetricValue>> TOTAL_COST_AND_USAGE_FIELD = SdkField
            .<Map<String, ComparisonMetricValue>> builder(MarshallingType.MAP)
            .memberName("TotalCostAndUsage")
            .getter(getter(GetCostAndUsageComparisonsResponse::totalCostAndUsage))
            .setter(setter(Builder::totalCostAndUsage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCostAndUsage").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComparisonMetricValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComparisonMetricValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetCostAndUsageComparisonsResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COST_AND_USAGE_COMPARISONS_FIELD, TOTAL_COST_AND_USAGE_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CostAndUsageComparison> costAndUsageComparisons;

    private final Map<String, ComparisonMetricValue> totalCostAndUsage;

    private final String nextPageToken;

    private GetCostAndUsageComparisonsResponse(BuilderImpl builder) {
        super(builder);
        this.costAndUsageComparisons = builder.costAndUsageComparisons;
        this.totalCostAndUsage = builder.totalCostAndUsage;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CostAndUsageComparisons property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCostAndUsageComparisons() {
        return costAndUsageComparisons != null && !(costAndUsageComparisons instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of comparison results showing cost and usage metrics between <code>BaselineTimePeriod</code> and
     * <code>ComparisonTimePeriod</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCostAndUsageComparisons} method.
     * </p>
     * 
     * @return An array of comparison results showing cost and usage metrics between <code>BaselineTimePeriod</code> and
     *         <code>ComparisonTimePeriod</code>.
     */
    public final List<CostAndUsageComparison> costAndUsageComparisons() {
        return costAndUsageComparisons;
    }

    /**
     * For responses, this returns true if the service returned a value for the TotalCostAndUsage property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTotalCostAndUsage() {
        return totalCostAndUsage != null && !(totalCostAndUsage instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A summary of the total cost and usage, comparing amounts between <code>BaselineTimePeriod</code> and
     * <code>ComparisonTimePeriod</code> and their differences. This total represents the aggregate total across all
     * paginated results, if the response spans multiple pages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTotalCostAndUsage} method.
     * </p>
     * 
     * @return A summary of the total cost and usage, comparing amounts between <code>BaselineTimePeriod</code> and
     *         <code>ComparisonTimePeriod</code> and their differences. This total represents the aggregate total across
     *         all paginated results, if the response spans multiple pages.
     */
    public final Map<String, ComparisonMetricValue> totalCostAndUsage() {
        return totalCostAndUsage;
    }

    /**
     * <p>
     * The token to retrieve the next set of paginated results.
     * </p>
     * 
     * @return The token to retrieve the next set of paginated results.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCostAndUsageComparisons() ? costAndUsageComparisons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTotalCostAndUsage() ? totalCostAndUsage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostAndUsageComparisonsResponse)) {
            return false;
        }
        GetCostAndUsageComparisonsResponse other = (GetCostAndUsageComparisonsResponse) obj;
        return hasCostAndUsageComparisons() == other.hasCostAndUsageComparisons()
                && Objects.equals(costAndUsageComparisons(), other.costAndUsageComparisons())
                && hasTotalCostAndUsage() == other.hasTotalCostAndUsage()
                && Objects.equals(totalCostAndUsage(), other.totalCostAndUsage())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCostAndUsageComparisonsResponse")
                .add("CostAndUsageComparisons", hasCostAndUsageComparisons() ? costAndUsageComparisons() : null)
                .add("TotalCostAndUsage", hasTotalCostAndUsage() ? totalCostAndUsage() : null)
                .add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostAndUsageComparisons":
            return Optional.ofNullable(clazz.cast(costAndUsageComparisons()));
        case "TotalCostAndUsage":
            return Optional.ofNullable(clazz.cast(totalCostAndUsage()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CostAndUsageComparisons", COST_AND_USAGE_COMPARISONS_FIELD);
        map.put("TotalCostAndUsage", TOTAL_COST_AND_USAGE_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostAndUsageComparisonsResponse, T> g) {
        return obj -> g.apply((GetCostAndUsageComparisonsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCostAndUsageComparisonsResponse> {
        /**
         * <p>
         * An array of comparison results showing cost and usage metrics between <code>BaselineTimePeriod</code> and
         * <code>ComparisonTimePeriod</code>.
         * </p>
         * 
         * @param costAndUsageComparisons
         *        An array of comparison results showing cost and usage metrics between <code>BaselineTimePeriod</code>
         *        and <code>ComparisonTimePeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costAndUsageComparisons(Collection<CostAndUsageComparison> costAndUsageComparisons);

        /**
         * <p>
         * An array of comparison results showing cost and usage metrics between <code>BaselineTimePeriod</code> and
         * <code>ComparisonTimePeriod</code>.
         * </p>
         * 
         * @param costAndUsageComparisons
         *        An array of comparison results showing cost and usage metrics between <code>BaselineTimePeriod</code>
         *        and <code>ComparisonTimePeriod</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costAndUsageComparisons(CostAndUsageComparison... costAndUsageComparisons);

        /**
         * <p>
         * An array of comparison results showing cost and usage metrics between <code>BaselineTimePeriod</code> and
         * <code>ComparisonTimePeriod</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparison.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparison#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparison.Builder#build()} is called
         * immediately and its result is passed to {@link #costAndUsageComparisons(List<CostAndUsageComparison>)}.
         * 
         * @param costAndUsageComparisons
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.CostAndUsageComparison.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costAndUsageComparisons(java.util.Collection<CostAndUsageComparison>)
         */
        Builder costAndUsageComparisons(Consumer<CostAndUsageComparison.Builder>... costAndUsageComparisons);

        /**
         * <p>
         * A summary of the total cost and usage, comparing amounts between <code>BaselineTimePeriod</code> and
         * <code>ComparisonTimePeriod</code> and their differences. This total represents the aggregate total across all
         * paginated results, if the response spans multiple pages.
         * </p>
         * 
         * @param totalCostAndUsage
         *        A summary of the total cost and usage, comparing amounts between <code>BaselineTimePeriod</code> and
         *        <code>ComparisonTimePeriod</code> and their differences. This total represents the aggregate total
         *        across all paginated results, if the response spans multiple pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCostAndUsage(Map<String, ComparisonMetricValue> totalCostAndUsage);

        /**
         * <p>
         * The token to retrieve the next set of paginated results.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of paginated results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<CostAndUsageComparison> costAndUsageComparisons = DefaultSdkAutoConstructList.getInstance();

        private Map<String, ComparisonMetricValue> totalCostAndUsage = DefaultSdkAutoConstructMap.getInstance();

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostAndUsageComparisonsResponse model) {
            super(model);
            costAndUsageComparisons(model.costAndUsageComparisons);
            totalCostAndUsage(model.totalCostAndUsage);
            nextPageToken(model.nextPageToken);
        }

        public final List<CostAndUsageComparison.Builder> getCostAndUsageComparisons() {
            List<CostAndUsageComparison.Builder> result = CostAndUsageComparisonsCopier
                    .copyToBuilder(this.costAndUsageComparisons);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostAndUsageComparisons(Collection<CostAndUsageComparison.BuilderImpl> costAndUsageComparisons) {
            this.costAndUsageComparisons = CostAndUsageComparisonsCopier.copyFromBuilder(costAndUsageComparisons);
        }

        @Override
        public final Builder costAndUsageComparisons(Collection<CostAndUsageComparison> costAndUsageComparisons) {
            this.costAndUsageComparisons = CostAndUsageComparisonsCopier.copy(costAndUsageComparisons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAndUsageComparisons(CostAndUsageComparison... costAndUsageComparisons) {
            costAndUsageComparisons(Arrays.asList(costAndUsageComparisons));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAndUsageComparisons(Consumer<CostAndUsageComparison.Builder>... costAndUsageComparisons) {
            costAndUsageComparisons(Stream.of(costAndUsageComparisons)
                    .map(c -> CostAndUsageComparison.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, ComparisonMetricValue.Builder> getTotalCostAndUsage() {
            Map<String, ComparisonMetricValue.Builder> result = ComparisonMetricsCopier.copyToBuilder(this.totalCostAndUsage);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setTotalCostAndUsage(Map<String, ComparisonMetricValue.BuilderImpl> totalCostAndUsage) {
            this.totalCostAndUsage = ComparisonMetricsCopier.copyFromBuilder(totalCostAndUsage);
        }

        @Override
        public final Builder totalCostAndUsage(Map<String, ComparisonMetricValue> totalCostAndUsage) {
            this.totalCostAndUsage = ComparisonMetricsCopier.copy(totalCostAndUsage);
            return this;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        @Override
        public GetCostAndUsageComparisonsResponse build() {
            return new GetCostAndUsageComparisonsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
