/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a comparison of cost and usage metrics between two time periods.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostAndUsageComparison implements SdkPojo, Serializable,
        ToCopyableBuilder<CostAndUsageComparison.Builder, CostAndUsageComparison> {
    private static final SdkField<Expression> COST_AND_USAGE_SELECTOR_FIELD = SdkField
            .<Expression> builder(MarshallingType.SDK_POJO).memberName("CostAndUsageSelector")
            .getter(getter(CostAndUsageComparison::costAndUsageSelector)).setter(setter(Builder::costAndUsageSelector))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostAndUsageSelector").build())
            .build();

    private static final SdkField<Map<String, ComparisonMetricValue>> METRICS_FIELD = SdkField
            .<Map<String, ComparisonMetricValue>> builder(MarshallingType.MAP)
            .memberName("Metrics")
            .getter(getter(CostAndUsageComparison::metrics))
            .setter(setter(Builder::metrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ComparisonMetricValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComparisonMetricValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_AND_USAGE_SELECTOR_FIELD,
            METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Expression costAndUsageSelector;

    private final Map<String, ComparisonMetricValue> metrics;

    private CostAndUsageComparison(BuilderImpl builder) {
        this.costAndUsageSelector = builder.costAndUsageSelector;
        this.metrics = builder.metrics;
    }

    /**
     * Returns the value of the CostAndUsageSelector property for this object.
     * 
     * @return The value of the CostAndUsageSelector property for this object.
     */
    public final Expression costAndUsageSelector() {
        return costAndUsageSelector;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metrics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetrics() {
        return metrics != null && !(metrics instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of metric names to their comparison values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetrics} method.
     * </p>
     * 
     * @return A mapping of metric names to their comparison values.
     */
    public final Map<String, ComparisonMetricValue> metrics() {
        return metrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costAndUsageSelector());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetrics() ? metrics() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostAndUsageComparison)) {
            return false;
        }
        CostAndUsageComparison other = (CostAndUsageComparison) obj;
        return Objects.equals(costAndUsageSelector(), other.costAndUsageSelector()) && hasMetrics() == other.hasMetrics()
                && Objects.equals(metrics(), other.metrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostAndUsageComparison").add("CostAndUsageSelector", costAndUsageSelector())
                .add("Metrics", hasMetrics() ? metrics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostAndUsageSelector":
            return Optional.ofNullable(clazz.cast(costAndUsageSelector()));
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CostAndUsageSelector", COST_AND_USAGE_SELECTOR_FIELD);
        map.put("Metrics", METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostAndUsageComparison, T> g) {
        return obj -> g.apply((CostAndUsageComparison) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostAndUsageComparison> {
        /**
         * Sets the value of the CostAndUsageSelector property for this object.
         *
         * @param costAndUsageSelector
         *        The new value for the CostAndUsageSelector property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costAndUsageSelector(Expression costAndUsageSelector);

        /**
         * Sets the value of the CostAndUsageSelector property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Expression.Builder} avoiding the need to
         * create one manually via {@link Expression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #costAndUsageSelector(Expression)}.
         * 
         * @param costAndUsageSelector
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costAndUsageSelector(Expression)
         */
        default Builder costAndUsageSelector(Consumer<Expression.Builder> costAndUsageSelector) {
            return costAndUsageSelector(Expression.builder().applyMutation(costAndUsageSelector).build());
        }

        /**
         * <p>
         * A mapping of metric names to their comparison values.
         * </p>
         * 
         * @param metrics
         *        A mapping of metric names to their comparison values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(Map<String, ComparisonMetricValue> metrics);
    }

    static final class BuilderImpl implements Builder {
        private Expression costAndUsageSelector;

        private Map<String, ComparisonMetricValue> metrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostAndUsageComparison model) {
            costAndUsageSelector(model.costAndUsageSelector);
            metrics(model.metrics);
        }

        public final Expression.Builder getCostAndUsageSelector() {
            return costAndUsageSelector != null ? costAndUsageSelector.toBuilder() : null;
        }

        public final void setCostAndUsageSelector(Expression.BuilderImpl costAndUsageSelector) {
            this.costAndUsageSelector = costAndUsageSelector != null ? costAndUsageSelector.build() : null;
        }

        @Override
        public final Builder costAndUsageSelector(Expression costAndUsageSelector) {
            this.costAndUsageSelector = costAndUsageSelector;
            return this;
        }

        public final Map<String, ComparisonMetricValue.Builder> getMetrics() {
            Map<String, ComparisonMetricValue.Builder> result = ComparisonMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Map<String, ComparisonMetricValue.BuilderImpl> metrics) {
            this.metrics = ComparisonMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Map<String, ComparisonMetricValue> metrics) {
            this.metrics = ComparisonMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        public CostAndUsageComparison build() {
            return new CostAndUsageComparison(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
