/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the commitment purchase analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CommitmentPurchaseAnalysisConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CommitmentPurchaseAnalysisConfiguration.Builder, CommitmentPurchaseAnalysisConfiguration> {
    private static final SdkField<SavingsPlansPurchaseAnalysisConfiguration> SAVINGS_PLANS_PURCHASE_ANALYSIS_CONFIGURATION_FIELD = SdkField
            .<SavingsPlansPurchaseAnalysisConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SavingsPlansPurchaseAnalysisConfiguration")
            .getter(getter(CommitmentPurchaseAnalysisConfiguration::savingsPlansPurchaseAnalysisConfiguration))
            .setter(setter(Builder::savingsPlansPurchaseAnalysisConfiguration))
            .constructor(SavingsPlansPurchaseAnalysisConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SavingsPlansPurchaseAnalysisConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SAVINGS_PLANS_PURCHASE_ANALYSIS_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SavingsPlansPurchaseAnalysisConfiguration savingsPlansPurchaseAnalysisConfiguration;

    private CommitmentPurchaseAnalysisConfiguration(BuilderImpl builder) {
        this.savingsPlansPurchaseAnalysisConfiguration = builder.savingsPlansPurchaseAnalysisConfiguration;
    }

    /**
     * <p>
     * The configuration for the Savings Plans purchase analysis.
     * </p>
     * 
     * @return The configuration for the Savings Plans purchase analysis.
     */
    public final SavingsPlansPurchaseAnalysisConfiguration savingsPlansPurchaseAnalysisConfiguration() {
        return savingsPlansPurchaseAnalysisConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansPurchaseAnalysisConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CommitmentPurchaseAnalysisConfiguration)) {
            return false;
        }
        CommitmentPurchaseAnalysisConfiguration other = (CommitmentPurchaseAnalysisConfiguration) obj;
        return Objects.equals(savingsPlansPurchaseAnalysisConfiguration(), other.savingsPlansPurchaseAnalysisConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CommitmentPurchaseAnalysisConfiguration")
                .add("SavingsPlansPurchaseAnalysisConfiguration", savingsPlansPurchaseAnalysisConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansPurchaseAnalysisConfiguration":
            return Optional.ofNullable(clazz.cast(savingsPlansPurchaseAnalysisConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SavingsPlansPurchaseAnalysisConfiguration", SAVINGS_PLANS_PURCHASE_ANALYSIS_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CommitmentPurchaseAnalysisConfiguration, T> g) {
        return obj -> g.apply((CommitmentPurchaseAnalysisConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CommitmentPurchaseAnalysisConfiguration> {
        /**
         * <p>
         * The configuration for the Savings Plans purchase analysis.
         * </p>
         * 
         * @param savingsPlansPurchaseAnalysisConfiguration
         *        The configuration for the Savings Plans purchase analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansPurchaseAnalysisConfiguration(
                SavingsPlansPurchaseAnalysisConfiguration savingsPlansPurchaseAnalysisConfiguration);

        /**
         * <p>
         * The configuration for the Savings Plans purchase analysis.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SavingsPlansPurchaseAnalysisConfiguration.Builder} avoiding the need to create one manually via
         * {@link SavingsPlansPurchaseAnalysisConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SavingsPlansPurchaseAnalysisConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #savingsPlansPurchaseAnalysisConfiguration(SavingsPlansPurchaseAnalysisConfiguration)}.
         * 
         * @param savingsPlansPurchaseAnalysisConfiguration
         *        a consumer that will call methods on {@link SavingsPlansPurchaseAnalysisConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansPurchaseAnalysisConfiguration(SavingsPlansPurchaseAnalysisConfiguration)
         */
        default Builder savingsPlansPurchaseAnalysisConfiguration(
                Consumer<SavingsPlansPurchaseAnalysisConfiguration.Builder> savingsPlansPurchaseAnalysisConfiguration) {
            return savingsPlansPurchaseAnalysisConfiguration(SavingsPlansPurchaseAnalysisConfiguration.builder()
                    .applyMutation(savingsPlansPurchaseAnalysisConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SavingsPlansPurchaseAnalysisConfiguration savingsPlansPurchaseAnalysisConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CommitmentPurchaseAnalysisConfiguration model) {
            savingsPlansPurchaseAnalysisConfiguration(model.savingsPlansPurchaseAnalysisConfiguration);
        }

        public final SavingsPlansPurchaseAnalysisConfiguration.Builder getSavingsPlansPurchaseAnalysisConfiguration() {
            return savingsPlansPurchaseAnalysisConfiguration != null ? savingsPlansPurchaseAnalysisConfiguration.toBuilder()
                    : null;
        }

        public final void setSavingsPlansPurchaseAnalysisConfiguration(
                SavingsPlansPurchaseAnalysisConfiguration.BuilderImpl savingsPlansPurchaseAnalysisConfiguration) {
            this.savingsPlansPurchaseAnalysisConfiguration = savingsPlansPurchaseAnalysisConfiguration != null ? savingsPlansPurchaseAnalysisConfiguration
                    .build() : null;
        }

        @Override
        public final Builder savingsPlansPurchaseAnalysisConfiguration(
                SavingsPlansPurchaseAnalysisConfiguration savingsPlansPurchaseAnalysisConfiguration) {
            this.savingsPlansPurchaseAnalysisConfiguration = savingsPlansPurchaseAnalysisConfiguration;
            return this;
        }

        @Override
        public CommitmentPurchaseAnalysisConfiguration build() {
            return new CommitmentPurchaseAnalysisConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
