/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.Granularity;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinition;
import software.amazon.awssdk.services.costexplorer.model.GroupDefinitionsCopier;
import software.amazon.awssdk.services.costexplorer.model.MetricNamesCopier;
import software.amazon.awssdk.services.costexplorer.model.SortDefinition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservationCoverageRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetReservationCoverageRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::timePeriod)).setter(GetReservationCoverageRequest.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<List<GroupDefinition>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupBy").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::groupBy)).setter(GetReservationCoverageRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Granularity").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::granularityAsString)).setter(GetReservationCoverageRequest.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::filter)).setter(GetReservationCoverageRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<List<String>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::metrics)).setter(GetReservationCoverageRequest.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::nextPageToken)).setter(GetReservationCoverageRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<SortDefinition> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SortBy").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::sortBy)).setter(GetReservationCoverageRequest.setter(Builder::sortBy)).constructor(SortDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetReservationCoverageRequest.getter(GetReservationCoverageRequest::maxResults)).setter(GetReservationCoverageRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, GROUP_BY_FIELD, GRANULARITY_FIELD, FILTER_FIELD, METRICS_FIELD, NEXT_PAGE_TOKEN_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetReservationCoverageRequest.memberNameToFieldInitializer();
    private final DateInterval timePeriod;
    private final List<GroupDefinition> groupBy;
    private final String granularity;
    private final Expression filter;
    private final List<String> metrics;
    private final String nextPageToken;
    private final SortDefinition sortBy;
    private final Integer maxResults;

    private GetReservationCoverageRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.groupBy = builder.groupBy;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
        this.metrics = builder.metrics;
        this.nextPageToken = builder.nextPageToken;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
    }

    public final DateInterval timePeriod() {
        return this.timePeriod;
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<GroupDefinition> groupBy() {
        return this.groupBy;
    }

    public final Granularity granularity() {
        return Granularity.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final Expression filter() {
        return this.filter;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<String> metrics() {
        return this.metrics;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final SortDefinition sortBy() {
        return this.sortBy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationCoverageRequest)) {
            return false;
        }
        GetReservationCoverageRequest other = (GetReservationCoverageRequest)((Object)obj);
        return Objects.equals(this.timePeriod(), other.timePeriod()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupBy(), other.groupBy()) && Objects.equals(this.granularityAsString(), other.granularityAsString()) && Objects.equals(this.filter(), other.filter()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.sortBy(), other.sortBy()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetReservationCoverageRequest").add("TimePeriod", (Object)this.timePeriod()).add("GroupBy", this.hasGroupBy() ? this.groupBy() : null).add("Granularity", (Object)this.granularityAsString()).add("Filter", (Object)this.filter()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("NextPageToken", (Object)this.nextPageToken()).add("SortBy", (Object)this.sortBy()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "GroupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("GroupBy", GROUP_BY_FIELD);
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("NextPageToken", NEXT_PAGE_TOKEN_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReservationCoverageRequest, T> g) {
        return obj -> g.apply((GetReservationCoverageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private List<GroupDefinition> groupBy = DefaultSdkAutoConstructList.getInstance();
        private String granularity;
        private Expression filter;
        private List<String> metrics = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;
        private SortDefinition sortBy;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationCoverageRequest model) {
            super(model);
            this.timePeriod(model.timePeriod);
            this.groupBy(model.groupBy);
            this.granularity(model.granularity);
            this.filter(model.filter);
            this.metrics(model.metrics);
            this.nextPageToken(model.nextPageToken);
            this.sortBy(model.sortBy);
            this.maxResults(model.maxResults);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final List<GroupDefinition.Builder> getGroupBy() {
            List<GroupDefinition.Builder> result = GroupDefinitionsCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<GroupDefinition.BuilderImpl> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<GroupDefinition> groupBy) {
            this.groupBy = GroupDefinitionsCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(GroupDefinition ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<GroupDefinition.Builder> ... groupBy) {
            this.groupBy(Stream.of(groupBy).map(c -> (GroupDefinition)((GroupDefinition.Builder)GroupDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final Collection<String> getMetrics() {
            if (this.metrics instanceof SdkAutoConstructList) {
                return null;
            }
            return this.metrics;
        }

        public final void setMetrics(Collection<String> metrics) {
            this.metrics = MetricNamesCopier.copy(metrics);
        }

        @Override
        public final Builder metrics(Collection<String> metrics) {
            this.metrics = MetricNamesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(String ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final SortDefinition.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(SortDefinition.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(SortDefinition sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReservationCoverageRequest build() {
            return new GetReservationCoverageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReservationCoverageRequest> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder groupBy(Collection<GroupDefinition> var1);

        public Builder groupBy(GroupDefinition ... var1);

        public Builder groupBy(Consumer<GroupDefinition.Builder> ... var1);

        public Builder granularity(String var1);

        public Builder granularity(Granularity var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder metrics(Collection<String> var1);

        public Builder metrics(String ... var1);

        public Builder nextPageToken(String var1);

        public Builder sortBy(SortDefinition var1);

        default public Builder sortBy(Consumer<SortDefinition.Builder> sortBy) {
            return this.sortBy((SortDefinition)((SortDefinition.Builder)SortDefinition.builder().applyMutation(sortBy)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

