/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostAllocationTag;
import software.amazon.awssdk.services.costexplorer.model.CostAllocationTagListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCostAllocationTagsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, ListCostAllocationTagsResponse> {
    private static final SdkField<List<CostAllocationTag>> COST_ALLOCATION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostAllocationTags").getter(ListCostAllocationTagsResponse.getter(ListCostAllocationTagsResponse::costAllocationTags)).setter(ListCostAllocationTagsResponse.setter(Builder::costAllocationTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostAllocationTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostAllocationTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCostAllocationTagsResponse.getter(ListCostAllocationTagsResponse::nextToken)).setter(ListCostAllocationTagsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_ALLOCATION_TAGS_FIELD, NEXT_TOKEN_FIELD));
    private final List<CostAllocationTag> costAllocationTags;
    private final String nextToken;

    private ListCostAllocationTagsResponse(BuilderImpl builder) {
        super(builder);
        this.costAllocationTags = builder.costAllocationTags;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCostAllocationTags() {
        return this.costAllocationTags != null && !(this.costAllocationTags instanceof SdkAutoConstructList);
    }

    public final List<CostAllocationTag> costAllocationTags() {
        return this.costAllocationTags;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostAllocationTags() ? this.costAllocationTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostAllocationTagsResponse)) {
            return false;
        }
        ListCostAllocationTagsResponse other = (ListCostAllocationTagsResponse)((Object)obj);
        return this.hasCostAllocationTags() == other.hasCostAllocationTags() && Objects.equals(this.costAllocationTags(), other.costAllocationTags()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCostAllocationTagsResponse").add("CostAllocationTags", this.hasCostAllocationTags() ? this.costAllocationTags() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostAllocationTags": {
                return Optional.ofNullable(clazz.cast(this.costAllocationTags()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCostAllocationTagsResponse, T> g) {
        return obj -> g.apply((ListCostAllocationTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<CostAllocationTag> costAllocationTags = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostAllocationTagsResponse model) {
            super(model);
            this.costAllocationTags(model.costAllocationTags);
            this.nextToken(model.nextToken);
        }

        public final List<CostAllocationTag.Builder> getCostAllocationTags() {
            List<CostAllocationTag.Builder> result = CostAllocationTagListCopier.copyToBuilder(this.costAllocationTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostAllocationTags(Collection<CostAllocationTag.BuilderImpl> costAllocationTags) {
            this.costAllocationTags = CostAllocationTagListCopier.copyFromBuilder(costAllocationTags);
        }

        @Override
        public final Builder costAllocationTags(Collection<CostAllocationTag> costAllocationTags) {
            this.costAllocationTags = CostAllocationTagListCopier.copy(costAllocationTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAllocationTags(CostAllocationTag ... costAllocationTags) {
            this.costAllocationTags(Arrays.asList(costAllocationTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costAllocationTags(Consumer<CostAllocationTag.Builder> ... costAllocationTags) {
            this.costAllocationTags(Stream.of(costAllocationTags).map(c -> (CostAllocationTag)((CostAllocationTag.Builder)CostAllocationTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCostAllocationTagsResponse build() {
            return new ListCostAllocationTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCostAllocationTagsResponse> {
        public Builder costAllocationTags(Collection<CostAllocationTag> var1);

        public Builder costAllocationTags(CostAllocationTag ... var1);

        public Builder costAllocationTags(Consumer<CostAllocationTag.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

