/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CurrentInstance;
import software.amazon.awssdk.services.costexplorer.model.FindingReasonCode;
import software.amazon.awssdk.services.costexplorer.model.FindingReasonCodesCopier;
import software.amazon.awssdk.services.costexplorer.model.ModifyRecommendationDetail;
import software.amazon.awssdk.services.costexplorer.model.RightsizingType;
import software.amazon.awssdk.services.costexplorer.model.TerminateRecommendationDetail;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RightsizingRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RightsizingRecommendation> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(RightsizingRecommendation.getter(RightsizingRecommendation::accountId)).setter(RightsizingRecommendation.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<CurrentInstance> CURRENT_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentInstance").getter(RightsizingRecommendation.getter(RightsizingRecommendation::currentInstance)).setter(RightsizingRecommendation.setter(Builder::currentInstance)).constructor(CurrentInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentInstance").build()}).build();
    private static final SdkField<String> RIGHTSIZING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RightsizingType").getter(RightsizingRecommendation.getter(RightsizingRecommendation::rightsizingTypeAsString)).setter(RightsizingRecommendation.setter(Builder::rightsizingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightsizingType").build()}).build();
    private static final SdkField<ModifyRecommendationDetail> MODIFY_RECOMMENDATION_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModifyRecommendationDetail").getter(RightsizingRecommendation.getter(RightsizingRecommendation::modifyRecommendationDetail)).setter(RightsizingRecommendation.setter(Builder::modifyRecommendationDetail)).constructor(ModifyRecommendationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifyRecommendationDetail").build()}).build();
    private static final SdkField<TerminateRecommendationDetail> TERMINATE_RECOMMENDATION_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TerminateRecommendationDetail").getter(RightsizingRecommendation.getter(RightsizingRecommendation::terminateRecommendationDetail)).setter(RightsizingRecommendation.setter(Builder::terminateRecommendationDetail)).constructor(TerminateRecommendationDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminateRecommendationDetail").build()}).build();
    private static final SdkField<List<String>> FINDING_REASON_CODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FindingReasonCodes").getter(RightsizingRecommendation.getter(RightsizingRecommendation::findingReasonCodesAsStrings)).setter(RightsizingRecommendation.setter(Builder::findingReasonCodesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingReasonCodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, CURRENT_INSTANCE_FIELD, RIGHTSIZING_TYPE_FIELD, MODIFY_RECOMMENDATION_DETAIL_FIELD, TERMINATE_RECOMMENDATION_DETAIL_FIELD, FINDING_REASON_CODES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final CurrentInstance currentInstance;
    private final String rightsizingType;
    private final ModifyRecommendationDetail modifyRecommendationDetail;
    private final TerminateRecommendationDetail terminateRecommendationDetail;
    private final List<String> findingReasonCodes;

    private RightsizingRecommendation(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.currentInstance = builder.currentInstance;
        this.rightsizingType = builder.rightsizingType;
        this.modifyRecommendationDetail = builder.modifyRecommendationDetail;
        this.terminateRecommendationDetail = builder.terminateRecommendationDetail;
        this.findingReasonCodes = builder.findingReasonCodes;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final CurrentInstance currentInstance() {
        return this.currentInstance;
    }

    public final RightsizingType rightsizingType() {
        return RightsizingType.fromValue(this.rightsizingType);
    }

    public final String rightsizingTypeAsString() {
        return this.rightsizingType;
    }

    public final ModifyRecommendationDetail modifyRecommendationDetail() {
        return this.modifyRecommendationDetail;
    }

    public final TerminateRecommendationDetail terminateRecommendationDetail() {
        return this.terminateRecommendationDetail;
    }

    public final List<FindingReasonCode> findingReasonCodes() {
        return FindingReasonCodesCopier.copyStringToEnum(this.findingReasonCodes);
    }

    public final boolean hasFindingReasonCodes() {
        return this.findingReasonCodes != null && !(this.findingReasonCodes instanceof SdkAutoConstructList);
    }

    public final List<String> findingReasonCodesAsStrings() {
        return this.findingReasonCodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.rightsizingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifyRecommendationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminateRecommendationDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendation)) {
            return false;
        }
        RightsizingRecommendation other = (RightsizingRecommendation)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.currentInstance(), other.currentInstance()) && Objects.equals(this.rightsizingTypeAsString(), other.rightsizingTypeAsString()) && Objects.equals(this.modifyRecommendationDetail(), other.modifyRecommendationDetail()) && Objects.equals(this.terminateRecommendationDetail(), other.terminateRecommendationDetail()) && this.hasFindingReasonCodes() == other.hasFindingReasonCodes() && Objects.equals(this.findingReasonCodesAsStrings(), other.findingReasonCodesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"RightsizingRecommendation").add("AccountId", (Object)this.accountId()).add("CurrentInstance", (Object)this.currentInstance()).add("RightsizingType", (Object)this.rightsizingTypeAsString()).add("ModifyRecommendationDetail", (Object)this.modifyRecommendationDetail()).add("TerminateRecommendationDetail", (Object)this.terminateRecommendationDetail()).add("FindingReasonCodes", this.hasFindingReasonCodes() ? this.findingReasonCodesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "CurrentInstance": {
                return Optional.ofNullable(clazz.cast(this.currentInstance()));
            }
            case "RightsizingType": {
                return Optional.ofNullable(clazz.cast(this.rightsizingTypeAsString()));
            }
            case "ModifyRecommendationDetail": {
                return Optional.ofNullable(clazz.cast(this.modifyRecommendationDetail()));
            }
            case "TerminateRecommendationDetail": {
                return Optional.ofNullable(clazz.cast(this.terminateRecommendationDetail()));
            }
            case "FindingReasonCodes": {
                return Optional.ofNullable(clazz.cast(this.findingReasonCodesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendation, T> g) {
        return obj -> g.apply((RightsizingRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private CurrentInstance currentInstance;
        private String rightsizingType;
        private ModifyRecommendationDetail modifyRecommendationDetail;
        private TerminateRecommendationDetail terminateRecommendationDetail;
        private List<String> findingReasonCodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendation model) {
            this.accountId(model.accountId);
            this.currentInstance(model.currentInstance);
            this.rightsizingType(model.rightsizingType);
            this.modifyRecommendationDetail(model.modifyRecommendationDetail);
            this.terminateRecommendationDetail(model.terminateRecommendationDetail);
            this.findingReasonCodesWithStrings(model.findingReasonCodes);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final CurrentInstance.Builder getCurrentInstance() {
            return this.currentInstance != null ? this.currentInstance.toBuilder() : null;
        }

        public final void setCurrentInstance(CurrentInstance.BuilderImpl currentInstance) {
            this.currentInstance = currentInstance != null ? currentInstance.build() : null;
        }

        @Override
        public final Builder currentInstance(CurrentInstance currentInstance) {
            this.currentInstance = currentInstance;
            return this;
        }

        public final String getRightsizingType() {
            return this.rightsizingType;
        }

        public final void setRightsizingType(String rightsizingType) {
            this.rightsizingType = rightsizingType;
        }

        @Override
        public final Builder rightsizingType(String rightsizingType) {
            this.rightsizingType = rightsizingType;
            return this;
        }

        @Override
        public final Builder rightsizingType(RightsizingType rightsizingType) {
            this.rightsizingType(rightsizingType == null ? null : rightsizingType.toString());
            return this;
        }

        public final ModifyRecommendationDetail.Builder getModifyRecommendationDetail() {
            return this.modifyRecommendationDetail != null ? this.modifyRecommendationDetail.toBuilder() : null;
        }

        public final void setModifyRecommendationDetail(ModifyRecommendationDetail.BuilderImpl modifyRecommendationDetail) {
            this.modifyRecommendationDetail = modifyRecommendationDetail != null ? modifyRecommendationDetail.build() : null;
        }

        @Override
        public final Builder modifyRecommendationDetail(ModifyRecommendationDetail modifyRecommendationDetail) {
            this.modifyRecommendationDetail = modifyRecommendationDetail;
            return this;
        }

        public final TerminateRecommendationDetail.Builder getTerminateRecommendationDetail() {
            return this.terminateRecommendationDetail != null ? this.terminateRecommendationDetail.toBuilder() : null;
        }

        public final void setTerminateRecommendationDetail(TerminateRecommendationDetail.BuilderImpl terminateRecommendationDetail) {
            this.terminateRecommendationDetail = terminateRecommendationDetail != null ? terminateRecommendationDetail.build() : null;
        }

        @Override
        public final Builder terminateRecommendationDetail(TerminateRecommendationDetail terminateRecommendationDetail) {
            this.terminateRecommendationDetail = terminateRecommendationDetail;
            return this;
        }

        public final Collection<String> getFindingReasonCodes() {
            if (this.findingReasonCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.findingReasonCodes;
        }

        public final void setFindingReasonCodes(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = FindingReasonCodesCopier.copy(findingReasonCodes);
        }

        @Override
        public final Builder findingReasonCodesWithStrings(Collection<String> findingReasonCodes) {
            this.findingReasonCodes = FindingReasonCodesCopier.copy(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodesWithStrings(String ... findingReasonCodes) {
            this.findingReasonCodesWithStrings(Arrays.asList(findingReasonCodes));
            return this;
        }

        @Override
        public final Builder findingReasonCodes(Collection<FindingReasonCode> findingReasonCodes) {
            this.findingReasonCodes = FindingReasonCodesCopier.copyEnumToString(findingReasonCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingReasonCodes(FindingReasonCode ... findingReasonCodes) {
            this.findingReasonCodes(Arrays.asList(findingReasonCodes));
            return this;
        }

        public RightsizingRecommendation build() {
            return new RightsizingRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RightsizingRecommendation> {
        public Builder accountId(String var1);

        public Builder currentInstance(CurrentInstance var1);

        default public Builder currentInstance(Consumer<CurrentInstance.Builder> currentInstance) {
            return this.currentInstance((CurrentInstance)((CurrentInstance.Builder)CurrentInstance.builder().applyMutation(currentInstance)).build());
        }

        public Builder rightsizingType(String var1);

        public Builder rightsizingType(RightsizingType var1);

        public Builder modifyRecommendationDetail(ModifyRecommendationDetail var1);

        default public Builder modifyRecommendationDetail(Consumer<ModifyRecommendationDetail.Builder> modifyRecommendationDetail) {
            return this.modifyRecommendationDetail((ModifyRecommendationDetail)((ModifyRecommendationDetail.Builder)ModifyRecommendationDetail.builder().applyMutation(modifyRecommendationDetail)).build());
        }

        public Builder terminateRecommendationDetail(TerminateRecommendationDetail var1);

        default public Builder terminateRecommendationDetail(Consumer<TerminateRecommendationDetail.Builder> terminateRecommendationDetail) {
            return this.terminateRecommendationDetail((TerminateRecommendationDetail)((TerminateRecommendationDetail.Builder)TerminateRecommendationDetail.builder().applyMutation(terminateRecommendationDetail)).build());
        }

        public Builder findingReasonCodesWithStrings(Collection<String> var1);

        public Builder findingReasonCodesWithStrings(String ... var1);

        public Builder findingReasonCodes(Collection<FindingReasonCode> var1);

        public Builder findingReasonCodes(FindingReasonCode ... var1);
    }
}

