/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class CostCategoryReferencesListCopier {
    static List<CostCategoryReference> copy(Collection<? extends CostCategoryReference> costCategoryReferencesListParam) {
        List<CostCategoryReference> list;
        if (costCategoryReferencesListParam == null || costCategoryReferencesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CostCategoryReference> modifiableList = new ArrayList<>();
            costCategoryReferencesListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CostCategoryReference> copyFromBuilder(
            Collection<? extends CostCategoryReference.Builder> costCategoryReferencesListParam) {
        List<CostCategoryReference> list;
        if (costCategoryReferencesListParam == null || costCategoryReferencesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CostCategoryReference> modifiableList = new ArrayList<>();
            costCategoryReferencesListParam.forEach(entry -> {
                CostCategoryReference member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<CostCategoryReference.Builder> copyToBuilder(
            Collection<? extends CostCategoryReference> costCategoryReferencesListParam) {
        List<CostCategoryReference.Builder> list;
        if (costCategoryReferencesListParam == null || costCategoryReferencesListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<CostCategoryReference.Builder> modifiableList = new ArrayList<>();
            costCategoryReferencesListParam.forEach(entry -> {
                CostCategoryReference.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
