/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2InstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2InstanceDetails> {
    private static final SdkField<String> FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Family").getter(EC2InstanceDetails.getter(EC2InstanceDetails::family)).setter(EC2InstanceDetails.setter(Builder::family)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Family").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(EC2InstanceDetails.getter(EC2InstanceDetails::instanceType)).setter(EC2InstanceDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(EC2InstanceDetails.getter(EC2InstanceDetails::region)).setter(EC2InstanceDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(EC2InstanceDetails.getter(EC2InstanceDetails::availabilityZone)).setter(EC2InstanceDetails.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Platform").getter(EC2InstanceDetails.getter(EC2InstanceDetails::platform)).setter(EC2InstanceDetails.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()}).build();
    private static final SdkField<String> TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Tenancy").getter(EC2InstanceDetails.getter(EC2InstanceDetails::tenancy)).setter(EC2InstanceDetails.setter(Builder::tenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()}).build();
    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CurrentGeneration").getter(EC2InstanceDetails.getter(EC2InstanceDetails::currentGeneration)).setter(EC2InstanceDetails.setter(Builder::currentGeneration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()}).build();
    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SizeFlexEligible").getter(EC2InstanceDetails.getter(EC2InstanceDetails::sizeFlexEligible)).setter(EC2InstanceDetails.setter(Builder::sizeFlexEligible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAMILY_FIELD, INSTANCE_TYPE_FIELD, REGION_FIELD, AVAILABILITY_ZONE_FIELD, PLATFORM_FIELD, TENANCY_FIELD, CURRENT_GENERATION_FIELD, SIZE_FLEX_ELIGIBLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String family;
    private final String instanceType;
    private final String region;
    private final String availabilityZone;
    private final String platform;
    private final String tenancy;
    private final Boolean currentGeneration;
    private final Boolean sizeFlexEligible;

    private EC2InstanceDetails(BuilderImpl builder) {
        this.family = builder.family;
        this.instanceType = builder.instanceType;
        this.region = builder.region;
        this.availabilityZone = builder.availabilityZone;
        this.platform = builder.platform;
        this.tenancy = builder.tenancy;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    public final String family() {
        return this.family;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final String region() {
        return this.region;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String platform() {
        return this.platform;
    }

    public final String tenancy() {
        return this.tenancy;
    }

    public final Boolean currentGeneration() {
        return this.currentGeneration;
    }

    public final Boolean sizeFlexEligible() {
        return this.sizeFlexEligible;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.family());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.platform());
        hashCode = 31 * hashCode + Objects.hashCode(this.tenancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeFlexEligible());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceDetails)) {
            return false;
        }
        EC2InstanceDetails other = (EC2InstanceDetails)obj;
        return Objects.equals(this.family(), other.family()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.platform(), other.platform()) && Objects.equals(this.tenancy(), other.tenancy()) && Objects.equals(this.currentGeneration(), other.currentGeneration()) && Objects.equals(this.sizeFlexEligible(), other.sizeFlexEligible());
    }

    public final String toString() {
        return ToString.builder((String)"EC2InstanceDetails").add("Family", (Object)this.family()).add("InstanceType", (Object)this.instanceType()).add("Region", (Object)this.region()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Platform", (Object)this.platform()).add("Tenancy", (Object)this.tenancy()).add("CurrentGeneration", (Object)this.currentGeneration()).add("SizeFlexEligible", (Object)this.sizeFlexEligible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Family": {
                return Optional.ofNullable(clazz.cast(this.family()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platform()));
            }
            case "Tenancy": {
                return Optional.ofNullable(clazz.cast(this.tenancy()));
            }
            case "CurrentGeneration": {
                return Optional.ofNullable(clazz.cast(this.currentGeneration()));
            }
            case "SizeFlexEligible": {
                return Optional.ofNullable(clazz.cast(this.sizeFlexEligible()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceDetails, T> g) {
        return obj -> g.apply((EC2InstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String family;
        private String instanceType;
        private String region;
        private String availabilityZone;
        private String platform;
        private String tenancy;
        private Boolean currentGeneration;
        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceDetails model) {
            this.family(model.family);
            this.instanceType(model.instanceType);
            this.region(model.region);
            this.availabilityZone(model.availabilityZone);
            this.platform(model.platform);
            this.tenancy(model.tenancy);
            this.currentGeneration(model.currentGeneration);
            this.sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getFamily() {
            return this.family;
        }

        @Override
        public final Builder family(String family) {
            this.family = family;
            return this;
        }

        public final void setFamily(String family) {
            this.family = family;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getPlatform() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getTenancy() {
            return this.tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final Boolean getCurrentGeneration() {
            return this.currentGeneration;
        }

        @Override
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        public final Boolean getSizeFlexEligible() {
            return this.sizeFlexEligible;
        }

        @Override
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        public EC2InstanceDetails build() {
            return new EC2InstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2InstanceDetails> {
        public Builder family(String var1);

        public Builder instanceType(String var1);

        public Builder region(String var1);

        public Builder availabilityZone(String var1);

        public Builder platform(String var1);

        public Builder tenancy(String var1);

        public Builder currentGeneration(Boolean var1);

        public Builder sizeFlexEligible(Boolean var1);
    }
}

