/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributes;
import software.amazon.awssdk.services.costexplorer.model.DimensionValuesWithAttributesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDimensionValuesResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetDimensionValuesResponse> {
    private static final SdkField<List<DimensionValuesWithAttributes>> DIMENSION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DimensionValues").getter(GetDimensionValuesResponse.getter(GetDimensionValuesResponse::dimensionValues)).setter(GetDimensionValuesResponse.setter(Builder::dimensionValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DimensionValuesWithAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RETURN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReturnSize").getter(GetDimensionValuesResponse.getter(GetDimensionValuesResponse::returnSize)).setter(GetDimensionValuesResponse.setter(Builder::returnSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnSize").build()}).build();
    private static final SdkField<Integer> TOTAL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalSize").getter(GetDimensionValuesResponse.getter(GetDimensionValuesResponse::totalSize)).setter(GetDimensionValuesResponse.setter(Builder::totalSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetDimensionValuesResponse.getter(GetDimensionValuesResponse::nextPageToken)).setter(GetDimensionValuesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_VALUES_FIELD, RETURN_SIZE_FIELD, TOTAL_SIZE_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<DimensionValuesWithAttributes> dimensionValues;
    private final Integer returnSize;
    private final Integer totalSize;
    private final String nextPageToken;

    private GetDimensionValuesResponse(BuilderImpl builder) {
        super(builder);
        this.dimensionValues = builder.dimensionValues;
        this.returnSize = builder.returnSize;
        this.totalSize = builder.totalSize;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasDimensionValues() {
        return this.dimensionValues != null && !(this.dimensionValues instanceof SdkAutoConstructList);
    }

    public final List<DimensionValuesWithAttributes> dimensionValues() {
        return this.dimensionValues;
    }

    public final Integer returnSize() {
        return this.returnSize;
    }

    public final Integer totalSize() {
        return this.totalSize;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDimensionValues() ? this.dimensionValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionValuesResponse)) {
            return false;
        }
        GetDimensionValuesResponse other = (GetDimensionValuesResponse)((Object)obj);
        return this.hasDimensionValues() == other.hasDimensionValues() && Objects.equals(this.dimensionValues(), other.dimensionValues()) && Objects.equals(this.returnSize(), other.returnSize()) && Objects.equals(this.totalSize(), other.totalSize()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetDimensionValuesResponse").add("DimensionValues", this.hasDimensionValues() ? this.dimensionValues() : null).add("ReturnSize", (Object)this.returnSize()).add("TotalSize", (Object)this.totalSize()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DimensionValues": {
                return Optional.ofNullable(clazz.cast(this.dimensionValues()));
            }
            case "ReturnSize": {
                return Optional.ofNullable(clazz.cast(this.returnSize()));
            }
            case "TotalSize": {
                return Optional.ofNullable(clazz.cast(this.totalSize()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionValuesResponse, T> g) {
        return obj -> g.apply((GetDimensionValuesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<DimensionValuesWithAttributes> dimensionValues = DefaultSdkAutoConstructList.getInstance();
        private Integer returnSize;
        private Integer totalSize;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionValuesResponse model) {
            super(model);
            this.dimensionValues(model.dimensionValues);
            this.returnSize(model.returnSize);
            this.totalSize(model.totalSize);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<DimensionValuesWithAttributes.Builder> getDimensionValues() {
            List<DimensionValuesWithAttributes.Builder> result = DimensionValuesWithAttributesListCopier.copyToBuilder(this.dimensionValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dimensionValues(Collection<DimensionValuesWithAttributes> dimensionValues) {
            this.dimensionValues = DimensionValuesWithAttributesListCopier.copy(dimensionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValues(DimensionValuesWithAttributes ... dimensionValues) {
            this.dimensionValues(Arrays.asList(dimensionValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionValues(Consumer<DimensionValuesWithAttributes.Builder> ... dimensionValues) {
            this.dimensionValues(Stream.of(dimensionValues).map(c -> (DimensionValuesWithAttributes)((DimensionValuesWithAttributes.Builder)DimensionValuesWithAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDimensionValues(Collection<DimensionValuesWithAttributes.BuilderImpl> dimensionValues) {
            this.dimensionValues = DimensionValuesWithAttributesListCopier.copyFromBuilder(dimensionValues);
        }

        public final Integer getReturnSize() {
            return this.returnSize;
        }

        @Override
        public final Builder returnSize(Integer returnSize) {
            this.returnSize = returnSize;
            return this;
        }

        public final void setReturnSize(Integer returnSize) {
            this.returnSize = returnSize;
        }

        public final Integer getTotalSize() {
            return this.totalSize;
        }

        @Override
        public final Builder totalSize(Integer totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public final void setTotalSize(Integer totalSize) {
            this.totalSize = totalSize;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetDimensionValuesResponse build() {
            return new GetDimensionValuesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDimensionValuesResponse> {
        public Builder dimensionValues(Collection<DimensionValuesWithAttributes> var1);

        public Builder dimensionValues(DimensionValuesWithAttributes ... var1);

        public Builder dimensionValues(Consumer<DimensionValuesWithAttributes.Builder> ... var1);

        public Builder returnSize(Integer var1);

        public Builder totalSize(Integer var1);

        public Builder nextPageToken(String var1);
    }
}

