/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RightsizingRecommendationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RightsizingRecommendationSummary> {
    private static final SdkField<String> TOTAL_RECOMMENDATION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TotalRecommendationCount").getter(RightsizingRecommendationSummary.getter(RightsizingRecommendationSummary::totalRecommendationCount)).setter(RightsizingRecommendationSummary.setter(Builder::totalRecommendationCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecommendationCount").build()}).build();
    private static final SdkField<String> ESTIMATED_TOTAL_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedTotalMonthlySavingsAmount").getter(RightsizingRecommendationSummary.getter(RightsizingRecommendationSummary::estimatedTotalMonthlySavingsAmount)).setter(RightsizingRecommendationSummary.setter(Builder::estimatedTotalMonthlySavingsAmount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTotalMonthlySavingsAmount").build()}).build();
    private static final SdkField<String> SAVINGS_CURRENCY_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SavingsCurrencyCode").getter(RightsizingRecommendationSummary.getter(RightsizingRecommendationSummary::savingsCurrencyCode)).setter(RightsizingRecommendationSummary.setter(Builder::savingsCurrencyCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsCurrencyCode").build()}).build();
    private static final SdkField<String> SAVINGS_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SavingsPercentage").getter(RightsizingRecommendationSummary.getter(RightsizingRecommendationSummary::savingsPercentage)).setter(RightsizingRecommendationSummary.setter(Builder::savingsPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_RECOMMENDATION_COUNT_FIELD, ESTIMATED_TOTAL_MONTHLY_SAVINGS_AMOUNT_FIELD, SAVINGS_CURRENCY_CODE_FIELD, SAVINGS_PERCENTAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String totalRecommendationCount;
    private final String estimatedTotalMonthlySavingsAmount;
    private final String savingsCurrencyCode;
    private final String savingsPercentage;

    private RightsizingRecommendationSummary(BuilderImpl builder) {
        this.totalRecommendationCount = builder.totalRecommendationCount;
        this.estimatedTotalMonthlySavingsAmount = builder.estimatedTotalMonthlySavingsAmount;
        this.savingsCurrencyCode = builder.savingsCurrencyCode;
        this.savingsPercentage = builder.savingsPercentage;
    }

    public final String totalRecommendationCount() {
        return this.totalRecommendationCount;
    }

    public final String estimatedTotalMonthlySavingsAmount() {
        return this.estimatedTotalMonthlySavingsAmount;
    }

    public final String savingsCurrencyCode() {
        return this.savingsCurrencyCode;
    }

    public final String savingsPercentage() {
        return this.savingsPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalRecommendationCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTotalMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsCurrencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendationSummary)) {
            return false;
        }
        RightsizingRecommendationSummary other = (RightsizingRecommendationSummary)obj;
        return Objects.equals(this.totalRecommendationCount(), other.totalRecommendationCount()) && Objects.equals(this.estimatedTotalMonthlySavingsAmount(), other.estimatedTotalMonthlySavingsAmount()) && Objects.equals(this.savingsCurrencyCode(), other.savingsCurrencyCode()) && Objects.equals(this.savingsPercentage(), other.savingsPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"RightsizingRecommendationSummary").add("TotalRecommendationCount", (Object)this.totalRecommendationCount()).add("EstimatedTotalMonthlySavingsAmount", (Object)this.estimatedTotalMonthlySavingsAmount()).add("SavingsCurrencyCode", (Object)this.savingsCurrencyCode()).add("SavingsPercentage", (Object)this.savingsPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalRecommendationCount": {
                return Optional.ofNullable(clazz.cast(this.totalRecommendationCount()));
            }
            case "EstimatedTotalMonthlySavingsAmount": {
                return Optional.ofNullable(clazz.cast(this.estimatedTotalMonthlySavingsAmount()));
            }
            case "SavingsCurrencyCode": {
                return Optional.ofNullable(clazz.cast(this.savingsCurrencyCode()));
            }
            case "SavingsPercentage": {
                return Optional.ofNullable(clazz.cast(this.savingsPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendationSummary, T> g) {
        return obj -> g.apply((RightsizingRecommendationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String totalRecommendationCount;
        private String estimatedTotalMonthlySavingsAmount;
        private String savingsCurrencyCode;
        private String savingsPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendationSummary model) {
            this.totalRecommendationCount(model.totalRecommendationCount);
            this.estimatedTotalMonthlySavingsAmount(model.estimatedTotalMonthlySavingsAmount);
            this.savingsCurrencyCode(model.savingsCurrencyCode);
            this.savingsPercentage(model.savingsPercentage);
        }

        public final String getTotalRecommendationCount() {
            return this.totalRecommendationCount;
        }

        public final void setTotalRecommendationCount(String totalRecommendationCount) {
            this.totalRecommendationCount = totalRecommendationCount;
        }

        @Override
        public final Builder totalRecommendationCount(String totalRecommendationCount) {
            this.totalRecommendationCount = totalRecommendationCount;
            return this;
        }

        public final String getEstimatedTotalMonthlySavingsAmount() {
            return this.estimatedTotalMonthlySavingsAmount;
        }

        public final void setEstimatedTotalMonthlySavingsAmount(String estimatedTotalMonthlySavingsAmount) {
            this.estimatedTotalMonthlySavingsAmount = estimatedTotalMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedTotalMonthlySavingsAmount(String estimatedTotalMonthlySavingsAmount) {
            this.estimatedTotalMonthlySavingsAmount = estimatedTotalMonthlySavingsAmount;
            return this;
        }

        public final String getSavingsCurrencyCode() {
            return this.savingsCurrencyCode;
        }

        public final void setSavingsCurrencyCode(String savingsCurrencyCode) {
            this.savingsCurrencyCode = savingsCurrencyCode;
        }

        @Override
        public final Builder savingsCurrencyCode(String savingsCurrencyCode) {
            this.savingsCurrencyCode = savingsCurrencyCode;
            return this;
        }

        public final String getSavingsPercentage() {
            return this.savingsPercentage;
        }

        public final void setSavingsPercentage(String savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
        }

        @Override
        public final Builder savingsPercentage(String savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
            return this;
        }

        public RightsizingRecommendationSummary build() {
            return new RightsizingRecommendationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RightsizingRecommendationSummary> {
        public Builder totalRecommendationCount(String var1);

        public Builder estimatedTotalMonthlySavingsAmount(String var1);

        public Builder savingsCurrencyCode(String var1);

        public Builder savingsPercentage(String var1);
    }
}

