/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.model.BillExpirationException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DataUnavailableException;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.costexplorer.model.LimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse;
import software.amazon.awssdk.services.costexplorer.model.RequestChangedException;
import software.amazon.awssdk.services.costexplorer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.costexplorer.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.costexplorer.model.UnknownMonitorException;
import software.amazon.awssdk.services.costexplorer.model.UnknownSubscriptionException;
import software.amazon.awssdk.services.costexplorer.model.UnresolvableUsageUnitException;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable;
import software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable;
import software.amazon.awssdk.services.costexplorer.transform.CreateAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.CreateAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.CreateCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DescribeCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomaliesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomalyMonitorsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomalySubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageWithResourcesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostCategoriesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetDimensionValuesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetRightsizingRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationDetailsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetUsageForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostCategoryDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ProvideAnomalyFeedbackRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCostExplorerClient
implements CostExplorerClient {
    private static final Logger log = Logger.loggerFor(DefaultCostExplorerClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCostExplorerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ce";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAnomalyMonitorResponse createAnomalyMonitor(CreateAnomalyMonitorRequest createAnomalyMonitorRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnomalyMonitorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, createAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnomalyMonitor");
            CreateAnomalyMonitorResponse createAnomalyMonitorResponse = (CreateAnomalyMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnomalyMonitor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAnomalyMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAnomalyMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$createAnomalyMonitor$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAnomalySubscriptionResponse createAnomalySubscription(CreateAnomalySubscriptionRequest createAnomalySubscriptionRequest) throws UnknownMonitorException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnomalySubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, createAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnomalySubscription");
            CreateAnomalySubscriptionResponse createAnomalySubscriptionResponse = (CreateAnomalySubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnomalySubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAnomalySubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAnomalySubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$createAnomalySubscription$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCostCategoryDefinitionResponse createCostCategoryDefinition(CreateCostCategoryDefinitionRequest createCostCategoryDefinitionRequest) throws ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, createCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCostCategoryDefinition");
            CreateCostCategoryDefinitionResponse createCostCategoryDefinitionResponse = (CreateCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$createCostCategoryDefinition$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnomalyMonitorResponse deleteAnomalyMonitor(DeleteAnomalyMonitorRequest deleteAnomalyMonitorRequest) throws LimitExceededException, UnknownMonitorException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalyMonitorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, deleteAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalyMonitor");
            DeleteAnomalyMonitorResponse deleteAnomalyMonitorResponse = (DeleteAnomalyMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalyMonitor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAnomalyMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnomalyMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$deleteAnomalyMonitor$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnomalySubscriptionResponse deleteAnomalySubscription(DeleteAnomalySubscriptionRequest deleteAnomalySubscriptionRequest) throws LimitExceededException, UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalySubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, deleteAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalySubscription");
            DeleteAnomalySubscriptionResponse deleteAnomalySubscriptionResponse = (DeleteAnomalySubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalySubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAnomalySubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnomalySubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$deleteAnomalySubscription$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest deleteCostCategoryDefinitionRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, deleteCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCostCategoryDefinition");
            DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinitionResponse = (DeleteCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$deleteCostCategoryDefinition$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCostCategoryDefinitionResponse describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest describeCostCategoryDefinitionRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, describeCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCostCategoryDefinition");
            DescribeCostCategoryDefinitionResponse describeCostCategoryDefinitionResponse = (DescribeCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$describeCostCategoryDefinition$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnomaliesResponse getAnomalies(GetAnomaliesRequest getAnomaliesRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomaliesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getAnomaliesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalies");
            GetAnomaliesResponse getAnomaliesResponse = (GetAnomaliesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnomaliesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnomaliesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnomaliesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getAnomalies$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnomalyMonitorsResponse getAnomalyMonitors(GetAnomalyMonitorsRequest getAnomalyMonitorsRequest) throws LimitExceededException, UnknownMonitorException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomalyMonitorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getAnomalyMonitorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalyMonitors");
            GetAnomalyMonitorsResponse getAnomalyMonitorsResponse = (GetAnomalyMonitorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalyMonitors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnomalyMonitorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnomalyMonitorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnomalyMonitorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getAnomalyMonitors$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnomalySubscriptionsResponse getAnomalySubscriptions(GetAnomalySubscriptionsRequest getAnomalySubscriptionsRequest) throws LimitExceededException, UnknownSubscriptionException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomalySubscriptionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getAnomalySubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalySubscriptions");
            GetAnomalySubscriptionsResponse getAnomalySubscriptionsResponse = (GetAnomalySubscriptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalySubscriptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnomalySubscriptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnomalySubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnomalySubscriptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getAnomalySubscriptions$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostAndUsageResponse getCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getCostAndUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsage");
            GetCostAndUsageResponse getCostAndUsageResponse = (GetCostAndUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostAndUsageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostAndUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostAndUsageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostAndUsage$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostAndUsageWithResourcesResponse getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest getCostAndUsageWithResourcesRequest) throws DataUnavailableException, LimitExceededException, BillExpirationException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageWithResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getCostAndUsageWithResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsageWithResources");
            GetCostAndUsageWithResourcesResponse getCostAndUsageWithResourcesResponse = (GetCostAndUsageWithResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsageWithResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostAndUsageWithResourcesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostAndUsageWithResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostAndUsageWithResourcesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostAndUsageWithResources$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostCategoriesResponse getCostCategories(GetCostCategoriesRequest getCostCategoriesRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostCategoriesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getCostCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostCategories");
            GetCostCategoriesResponse getCostCategoriesResponse = (GetCostCategoriesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostCategories").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostCategoriesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostCategoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostCategoriesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostCategories$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostForecastResponse getCostForecast(GetCostForecastRequest getCostForecastRequest) throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getCostForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostForecast");
            GetCostForecastResponse getCostForecastResponse = (GetCostForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetCostForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getCostForecast$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDimensionValuesResponse getDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDimensionValuesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getDimensionValuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDimensionValues");
            GetDimensionValuesResponse getDimensionValuesResponse = (GetDimensionValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDimensionValues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDimensionValuesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDimensionValuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDimensionValuesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getDimensionValues$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationCoverageResponse getReservationCoverage(GetReservationCoverageRequest getReservationCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationCoverageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getReservationCoverageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationCoverage");
            GetReservationCoverageResponse getReservationCoverageResponse = (GetReservationCoverageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationCoverage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationCoverageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationCoverageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getReservationCoverage$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationPurchaseRecommendationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getReservationPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationPurchaseRecommendation");
            GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendationResponse = (GetReservationPurchaseRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationPurchaseRecommendation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationPurchaseRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationPurchaseRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getReservationPurchaseRecommendation$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationUtilizationResponse getReservationUtilization(GetReservationUtilizationRequest getReservationUtilizationRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationUtilizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getReservationUtilizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationUtilization");
            GetReservationUtilizationResponse getReservationUtilizationResponse = (GetReservationUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationUtilization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationUtilizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationUtilizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getReservationUtilization$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRightsizingRecommendationResponse getRightsizingRecommendation(GetRightsizingRecommendationRequest getRightsizingRecommendationRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRightsizingRecommendationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getRightsizingRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRightsizingRecommendation");
            GetRightsizingRecommendationResponse getRightsizingRecommendationResponse = (GetRightsizingRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRightsizingRecommendation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRightsizingRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRightsizingRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRightsizingRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getRightsizingRecommendation$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansCoverageResponse getSavingsPlansCoverage(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansCoverageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansCoverageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansCoverage");
            GetSavingsPlansCoverageResponse getSavingsPlansCoverageResponse = (GetSavingsPlansCoverageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansCoverage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansCoverageRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansCoverageResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansCoverage$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetSavingsPlansCoverageIterable getSavingsPlansCoveragePaginator(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return new GetSavingsPlansCoverageIterable(this, this.applyPaginatorUserAgent(getSavingsPlansCoverageRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest getSavingsPlansPurchaseRecommendationRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansPurchaseRecommendationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansPurchaseRecommendation");
            GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendationResponse = (GetSavingsPlansPurchaseRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansPurchaseRecommendation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansPurchaseRecommendationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansPurchaseRecommendationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansPurchaseRecommendation$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansUtilizationResponse getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest getSavingsPlansUtilizationRequest) throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansUtilizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilization");
            GetSavingsPlansUtilizationResponse getSavingsPlansUtilizationResponse = (GetSavingsPlansUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansUtilizationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansUtilizationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansUtilization$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansUtilizationDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilizationDetails");
            GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetailsResponse = (GetSavingsPlansUtilizationDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilizationDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansUtilizationDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansUtilizationDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansUtilizationDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getSavingsPlansUtilizationDetails$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public GetSavingsPlansUtilizationDetailsIterable getSavingsPlansUtilizationDetailsPaginator(GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return new GetSavingsPlansUtilizationDetailsIterable(this, this.applyPaginatorUserAgent(getSavingsPlansUtilizationDetailsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTags");
            GetTagsResponse getTagsResponse = (GetTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getTags$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUsageForecastResponse getUsageForecast(GetUsageForecastRequest getUsageForecastRequest) throws LimitExceededException, DataUnavailableException, UnresolvableUsageUnitException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsageForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getUsageForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsageForecast");
            GetUsageForecastResponse getUsageForecastResponse = (GetUsageForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsageForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUsageForecastRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetUsageForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUsageForecastResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$getUsageForecast$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCostCategoryDefinitionsResponse listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostCategoryDefinitionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, listCostCategoryDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostCategoryDefinitions");
            ListCostCategoryDefinitionsResponse listCostCategoryDefinitionsResponse = (ListCostCategoryDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostCategoryDefinitions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCostCategoryDefinitionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCostCategoryDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCostCategoryDefinitionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$listCostCategoryDefinitions$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListCostCategoryDefinitionsIterable listCostCategoryDefinitionsPaginator(ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        return new ListCostCategoryDefinitionsIterable(this, this.applyPaginatorUserAgent(listCostCategoryDefinitionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvideAnomalyFeedbackResponse provideAnomalyFeedback(ProvideAnomalyFeedbackRequest provideAnomalyFeedbackRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvideAnomalyFeedbackResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, provideAnomalyFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvideAnomalyFeedback");
            ProvideAnomalyFeedbackResponse provideAnomalyFeedbackResponse = (ProvideAnomalyFeedbackResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvideAnomalyFeedback").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)provideAnomalyFeedbackRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ProvideAnomalyFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return provideAnomalyFeedbackResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$provideAnomalyFeedback$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnomalyMonitorResponse updateAnomalyMonitor(UpdateAnomalyMonitorRequest updateAnomalyMonitorRequest) throws LimitExceededException, UnknownMonitorException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalyMonitorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, updateAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomalyMonitor");
            UpdateAnomalyMonitorResponse updateAnomalyMonitorResponse = (UpdateAnomalyMonitorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomalyMonitor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAnomalyMonitorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnomalyMonitorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$updateAnomalyMonitor$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnomalySubscriptionResponse updateAnomalySubscription(UpdateAnomalySubscriptionRequest updateAnomalySubscriptionRequest) throws LimitExceededException, UnknownMonitorException, UnknownSubscriptionException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalySubscriptionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, updateAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomalySubscription");
            UpdateAnomalySubscriptionResponse updateAnomalySubscriptionResponse = (UpdateAnomalySubscriptionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomalySubscription").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAnomalySubscriptionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnomalySubscriptionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$updateAnomalySubscription$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCostCategoryDefinitionResponse updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest updateCostCategoryDefinitionRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, updateCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCostCategoryDefinition");
            UpdateCostCategoryDefinitionResponse updateCostCategoryDefinitionResponse = (UpdateCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCostCategoryDefinitionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCostCategoryDefinitionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerClient.lambda$updateCostCategoryDefinition$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CostExplorerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnknownMonitorException").exceptionBuilderSupplier(UnknownMonitorException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").exceptionBuilderSupplier(UnknownSubscriptionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestChangedException").exceptionBuilderSupplier(RequestChangedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataUnavailableException").exceptionBuilderSupplier(DataUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BillExpirationException").exceptionBuilderSupplier(BillExpirationException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CostExplorerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.152").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CostExplorerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateCostCategoryDefinition$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnomalySubscription$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnomalyMonitor$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$provideAnomalyFeedback$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCostCategoryDefinitions$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUsageForecast$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTags$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilizationDetails$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilization$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansPurchaseRecommendation$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansCoverage$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRightsizingRecommendation$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationUtilization$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationPurchaseRecommendation$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationCoverage$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDimensionValues$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostForecast$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostCategories$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostAndUsageWithResources$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostAndUsage$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalySubscriptions$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalyMonitors$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalies$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCostCategoryDefinition$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCostCategoryDefinition$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalySubscription$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalyMonitor$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCostCategoryDefinition$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnomalySubscription$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnomalyMonitor$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

