/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.AnomalyFeedbackType;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvideAnomalyFeedbackRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, ProvideAnomalyFeedbackRequest> {
    private static final SdkField<String> ANOMALY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnomalyId").getter(ProvideAnomalyFeedbackRequest.getter(ProvideAnomalyFeedbackRequest::anomalyId)).setter(ProvideAnomalyFeedbackRequest.setter(Builder::anomalyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyId").build()}).build();
    private static final SdkField<String> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feedback").getter(ProvideAnomalyFeedbackRequest.getter(ProvideAnomalyFeedbackRequest::feedbackAsString)).setter(ProvideAnomalyFeedbackRequest.setter(Builder::feedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_ID_FIELD, FEEDBACK_FIELD));
    private final String anomalyId;
    private final String feedback;

    private ProvideAnomalyFeedbackRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyId = builder.anomalyId;
        this.feedback = builder.feedback;
    }

    public final String anomalyId() {
        return this.anomalyId;
    }

    public final AnomalyFeedbackType feedback() {
        return AnomalyFeedbackType.fromValue(this.feedback);
    }

    public final String feedbackAsString() {
        return this.feedback;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvideAnomalyFeedbackRequest)) {
            return false;
        }
        ProvideAnomalyFeedbackRequest other = (ProvideAnomalyFeedbackRequest)((Object)obj);
        return Objects.equals(this.anomalyId(), other.anomalyId()) && Objects.equals(this.feedbackAsString(), other.feedbackAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ProvideAnomalyFeedbackRequest").add("AnomalyId", (Object)this.anomalyId()).add("Feedback", (Object)this.feedbackAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyId": {
                return Optional.ofNullable(clazz.cast(this.anomalyId()));
            }
            case "Feedback": {
                return Optional.ofNullable(clazz.cast(this.feedbackAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvideAnomalyFeedbackRequest, T> g) {
        return obj -> g.apply((ProvideAnomalyFeedbackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String anomalyId;
        private String feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvideAnomalyFeedbackRequest model) {
            super(model);
            this.anomalyId(model.anomalyId);
            this.feedback(model.feedback);
        }

        public final String getAnomalyId() {
            return this.anomalyId;
        }

        public final void setAnomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
        }

        @Override
        @Transient
        public final Builder anomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
            return this;
        }

        public final String getFeedback() {
            return this.feedback;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        @Transient
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        @Transient
        public final Builder feedback(AnomalyFeedbackType feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ProvideAnomalyFeedbackRequest build() {
            return new ProvideAnomalyFeedbackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvideAnomalyFeedbackRequest> {
        public Builder anomalyId(String var1);

        public Builder feedback(String var1);

        public Builder feedback(AnomalyFeedbackType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

