/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeMethod;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRuleParameter;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRuleParametersListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostCategorySplitChargeRuleTargetsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostCategorySplitChargeRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostCategorySplitChargeRule> {
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(CostCategorySplitChargeRule.getter(CostCategorySplitChargeRule::source)).setter(CostCategorySplitChargeRule.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<List<String>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(CostCategorySplitChargeRule.getter(CostCategorySplitChargeRule::targets)).setter(CostCategorySplitChargeRule.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Method").getter(CostCategorySplitChargeRule.getter(CostCategorySplitChargeRule::methodAsString)).setter(CostCategorySplitChargeRule.setter(Builder::method)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Method").build()}).build();
    private static final SdkField<List<CostCategorySplitChargeRuleParameter>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Parameters").getter(CostCategorySplitChargeRule.getter(CostCategorySplitChargeRule::parameters)).setter(CostCategorySplitChargeRule.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategorySplitChargeRuleParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD, TARGETS_FIELD, METHOD_FIELD, PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String source;
    private final List<String> targets;
    private final String method;
    private final List<CostCategorySplitChargeRuleParameter> parameters;

    private CostCategorySplitChargeRule(BuilderImpl builder) {
        this.source = builder.source;
        this.targets = builder.targets;
        this.method = builder.method;
        this.parameters = builder.parameters;
    }

    public final String source() {
        return this.source;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<String> targets() {
        return this.targets;
    }

    public final CostCategorySplitChargeMethod method() {
        return CostCategorySplitChargeMethod.fromValue(this.method);
    }

    public final String methodAsString() {
        return this.method;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructList);
    }

    public final List<CostCategorySplitChargeRuleParameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.methodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategorySplitChargeRule)) {
            return false;
        }
        CostCategorySplitChargeRule other = (CostCategorySplitChargeRule)obj;
        return Objects.equals(this.source(), other.source()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.methodAsString(), other.methodAsString()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters());
    }

    public final String toString() {
        return ToString.builder((String)"CostCategorySplitChargeRule").add("Source", (Object)this.source()).add("Targets", this.hasTargets() ? this.targets() : null).add("Method", (Object)this.methodAsString()).add("Parameters", this.hasParameters() ? this.parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "Method": {
                return Optional.ofNullable(clazz.cast(this.methodAsString()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategorySplitChargeRule, T> g) {
        return obj -> g.apply((CostCategorySplitChargeRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String source;
        private List<String> targets = DefaultSdkAutoConstructList.getInstance();
        private String method;
        private List<CostCategorySplitChargeRuleParameter> parameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategorySplitChargeRule model) {
            this.source(model.source);
            this.targets(model.targets);
            this.method(model.method);
            this.parameters(model.parameters);
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        @Transient
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final Collection<String> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets;
        }

        public final void setTargets(Collection<String> targets) {
            this.targets = CostCategorySplitChargeRuleTargetsListCopier.copy(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<String> targets) {
            this.targets = CostCategorySplitChargeRuleTargetsListCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(String ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(String method) {
            this.method = method;
        }

        @Override
        @Transient
        public final Builder method(String method) {
            this.method = method;
            return this;
        }

        @Override
        @Transient
        public final Builder method(CostCategorySplitChargeMethod method) {
            this.method(method == null ? null : method.toString());
            return this;
        }

        public final List<CostCategorySplitChargeRuleParameter.Builder> getParameters() {
            List<CostCategorySplitChargeRuleParameter.Builder> result = CostCategorySplitChargeRuleParametersListCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParameters(Collection<CostCategorySplitChargeRuleParameter.BuilderImpl> parameters) {
            this.parameters = CostCategorySplitChargeRuleParametersListCopier.copyFromBuilder(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Collection<CostCategorySplitChargeRuleParameter> parameters) {
            this.parameters = CostCategorySplitChargeRuleParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(CostCategorySplitChargeRuleParameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parameters(Consumer<CostCategorySplitChargeRuleParameter.Builder> ... parameters) {
            this.parameters(Stream.of(parameters).map(c -> (CostCategorySplitChargeRuleParameter)((CostCategorySplitChargeRuleParameter.Builder)CostCategorySplitChargeRuleParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CostCategorySplitChargeRule build() {
            return new CostCategorySplitChargeRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostCategorySplitChargeRule> {
        public Builder source(String var1);

        public Builder targets(Collection<String> var1);

        public Builder targets(String ... var1);

        public Builder method(String var1);

        public Builder method(CostCategorySplitChargeMethod var1);

        public Builder parameters(Collection<CostCategorySplitChargeRuleParameter> var1);

        public Builder parameters(CostCategorySplitChargeRuleParameter ... var1);

        public Builder parameters(Consumer<CostCategorySplitChargeRuleParameter.Builder> ... var1);
    }
}

