/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendation;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationConfiguration;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationListCopier;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationMetadata;
import software.amazon.awssdk.services.costexplorer.model.RightsizingRecommendationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetRightsizingRecommendationResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetRightsizingRecommendationResponse> {
    private static final SdkField<RightsizingRecommendationMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(GetRightsizingRecommendationResponse.getter(GetRightsizingRecommendationResponse::metadata)).setter(GetRightsizingRecommendationResponse.setter(Builder::metadata)).constructor(RightsizingRecommendationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<RightsizingRecommendationSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Summary").getter(GetRightsizingRecommendationResponse.getter(GetRightsizingRecommendationResponse::summary)).setter(GetRightsizingRecommendationResponse.setter(Builder::summary)).constructor(RightsizingRecommendationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()}).build();
    private static final SdkField<List<RightsizingRecommendation>> RIGHTSIZING_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RightsizingRecommendations").getter(GetRightsizingRecommendationResponse.getter(GetRightsizingRecommendationResponse::rightsizingRecommendations)).setter(GetRightsizingRecommendationResponse.setter(Builder::rightsizingRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightsizingRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RightsizingRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetRightsizingRecommendationResponse.getter(GetRightsizingRecommendationResponse::nextPageToken)).setter(GetRightsizingRecommendationResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<RightsizingRecommendationConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Configuration").getter(GetRightsizingRecommendationResponse.getter(GetRightsizingRecommendationResponse::configuration)).setter(GetRightsizingRecommendationResponse.setter(Builder::configuration)).constructor(RightsizingRecommendationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, SUMMARY_FIELD, RIGHTSIZING_RECOMMENDATIONS_FIELD, NEXT_PAGE_TOKEN_FIELD, CONFIGURATION_FIELD));
    private final RightsizingRecommendationMetadata metadata;
    private final RightsizingRecommendationSummary summary;
    private final List<RightsizingRecommendation> rightsizingRecommendations;
    private final String nextPageToken;
    private final RightsizingRecommendationConfiguration configuration;

    private GetRightsizingRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.summary = builder.summary;
        this.rightsizingRecommendations = builder.rightsizingRecommendations;
        this.nextPageToken = builder.nextPageToken;
        this.configuration = builder.configuration;
    }

    public final RightsizingRecommendationMetadata metadata() {
        return this.metadata;
    }

    public final RightsizingRecommendationSummary summary() {
        return this.summary;
    }

    public final boolean hasRightsizingRecommendations() {
        return this.rightsizingRecommendations != null && !(this.rightsizingRecommendations instanceof SdkAutoConstructList);
    }

    public final List<RightsizingRecommendation> rightsizingRecommendations() {
        return this.rightsizingRecommendations;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final RightsizingRecommendationConfiguration configuration() {
        return this.configuration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRightsizingRecommendations() ? this.rightsizingRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRightsizingRecommendationResponse)) {
            return false;
        }
        GetRightsizingRecommendationResponse other = (GetRightsizingRecommendationResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.summary(), other.summary()) && this.hasRightsizingRecommendations() == other.hasRightsizingRecommendations() && Objects.equals(this.rightsizingRecommendations(), other.rightsizingRecommendations()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"GetRightsizingRecommendationResponse").add("Metadata", (Object)this.metadata()).add("Summary", (Object)this.summary()).add("RightsizingRecommendations", this.hasRightsizingRecommendations() ? this.rightsizingRecommendations() : null).add("NextPageToken", (Object)this.nextPageToken()).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "Summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
            case "RightsizingRecommendations": {
                return Optional.ofNullable(clazz.cast(this.rightsizingRecommendations()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "Configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRightsizingRecommendationResponse, T> g) {
        return obj -> g.apply((GetRightsizingRecommendationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private RightsizingRecommendationMetadata metadata;
        private RightsizingRecommendationSummary summary;
        private List<RightsizingRecommendation> rightsizingRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;
        private RightsizingRecommendationConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRightsizingRecommendationResponse model) {
            super(model);
            this.metadata(model.metadata);
            this.summary(model.summary);
            this.rightsizingRecommendations(model.rightsizingRecommendations);
            this.nextPageToken(model.nextPageToken);
            this.configuration(model.configuration);
        }

        public final RightsizingRecommendationMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(RightsizingRecommendationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        @Transient
        public final Builder metadata(RightsizingRecommendationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final RightsizingRecommendationSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        public final void setSummary(RightsizingRecommendationSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        @Transient
        public final Builder summary(RightsizingRecommendationSummary summary) {
            this.summary = summary;
            return this;
        }

        public final List<RightsizingRecommendation.Builder> getRightsizingRecommendations() {
            List<RightsizingRecommendation.Builder> result = RightsizingRecommendationListCopier.copyToBuilder(this.rightsizingRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRightsizingRecommendations(Collection<RightsizingRecommendation.BuilderImpl> rightsizingRecommendations) {
            this.rightsizingRecommendations = RightsizingRecommendationListCopier.copyFromBuilder(rightsizingRecommendations);
        }

        @Override
        @Transient
        public final Builder rightsizingRecommendations(Collection<RightsizingRecommendation> rightsizingRecommendations) {
            this.rightsizingRecommendations = RightsizingRecommendationListCopier.copy(rightsizingRecommendations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rightsizingRecommendations(RightsizingRecommendation ... rightsizingRecommendations) {
            this.rightsizingRecommendations(Arrays.asList(rightsizingRecommendations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rightsizingRecommendations(Consumer<RightsizingRecommendation.Builder> ... rightsizingRecommendations) {
            this.rightsizingRecommendations(Stream.of(rightsizingRecommendations).map(c -> (RightsizingRecommendation)((RightsizingRecommendation.Builder)RightsizingRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final RightsizingRecommendationConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(RightsizingRecommendationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        @Transient
        public final Builder configuration(RightsizingRecommendationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public GetRightsizingRecommendationResponse build() {
            return new GetRightsizingRecommendationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetRightsizingRecommendationResponse> {
        public Builder metadata(RightsizingRecommendationMetadata var1);

        default public Builder metadata(Consumer<RightsizingRecommendationMetadata.Builder> metadata) {
            return this.metadata((RightsizingRecommendationMetadata)((RightsizingRecommendationMetadata.Builder)RightsizingRecommendationMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder summary(RightsizingRecommendationSummary var1);

        default public Builder summary(Consumer<RightsizingRecommendationSummary.Builder> summary) {
            return this.summary((RightsizingRecommendationSummary)((RightsizingRecommendationSummary.Builder)RightsizingRecommendationSummary.builder().applyMutation(summary)).build());
        }

        public Builder rightsizingRecommendations(Collection<RightsizingRecommendation> var1);

        public Builder rightsizingRecommendations(RightsizingRecommendation ... var1);

        public Builder rightsizingRecommendations(Consumer<RightsizingRecommendation.Builder> ... var1);

        public Builder nextPageToken(String var1);

        public Builder configuration(RightsizingRecommendationConfiguration var1);

        default public Builder configuration(Consumer<RightsizingRecommendationConfiguration.Builder> configuration) {
            return this.configuration((RightsizingRecommendationConfiguration)((RightsizingRecommendationConfiguration.Builder)RightsizingRecommendationConfiguration.builder().applyMutation(configuration)).build());
        }
    }
}

