/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryNamesListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryValuesListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostCategoriesResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetCostCategoriesResponse> {
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetCostCategoriesResponse.getter(GetCostCategoriesResponse::nextPageToken)).setter(GetCostCategoriesResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<List<String>> COST_CATEGORY_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostCategoryNames").getter(GetCostCategoriesResponse.getter(GetCostCategoriesResponse::costCategoryNames)).setter(GetCostCategoriesResponse.setter(Builder::costCategoryNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COST_CATEGORY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostCategoryValues").getter(GetCostCategoriesResponse.getter(GetCostCategoriesResponse::costCategoryValues)).setter(GetCostCategoriesResponse.setter(Builder::costCategoryValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> RETURN_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReturnSize").getter(GetCostCategoriesResponse.getter(GetCostCategoriesResponse::returnSize)).setter(GetCostCategoriesResponse.setter(Builder::returnSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnSize").build()}).build();
    private static final SdkField<Integer> TOTAL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalSize").getter(GetCostCategoriesResponse.getter(GetCostCategoriesResponse::totalSize)).setter(GetCostCategoriesResponse.setter(Builder::totalSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_PAGE_TOKEN_FIELD, COST_CATEGORY_NAMES_FIELD, COST_CATEGORY_VALUES_FIELD, RETURN_SIZE_FIELD, TOTAL_SIZE_FIELD));
    private final String nextPageToken;
    private final List<String> costCategoryNames;
    private final List<String> costCategoryValues;
    private final Integer returnSize;
    private final Integer totalSize;

    private GetCostCategoriesResponse(BuilderImpl builder) {
        super(builder);
        this.nextPageToken = builder.nextPageToken;
        this.costCategoryNames = builder.costCategoryNames;
        this.costCategoryValues = builder.costCategoryValues;
        this.returnSize = builder.returnSize;
        this.totalSize = builder.totalSize;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final boolean hasCostCategoryNames() {
        return this.costCategoryNames != null && !(this.costCategoryNames instanceof SdkAutoConstructList);
    }

    public final List<String> costCategoryNames() {
        return this.costCategoryNames;
    }

    public final boolean hasCostCategoryValues() {
        return this.costCategoryValues != null && !(this.costCategoryValues instanceof SdkAutoConstructList);
    }

    public final List<String> costCategoryValues() {
        return this.costCategoryValues;
    }

    public final Integer returnSize() {
        return this.returnSize;
    }

    public final Integer totalSize() {
        return this.totalSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostCategoryNames() ? this.costCategoryNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostCategoryValues() ? this.costCategoryValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSize());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostCategoriesResponse)) {
            return false;
        }
        GetCostCategoriesResponse other = (GetCostCategoriesResponse)((Object)obj);
        return Objects.equals(this.nextPageToken(), other.nextPageToken()) && this.hasCostCategoryNames() == other.hasCostCategoryNames() && Objects.equals(this.costCategoryNames(), other.costCategoryNames()) && this.hasCostCategoryValues() == other.hasCostCategoryValues() && Objects.equals(this.costCategoryValues(), other.costCategoryValues()) && Objects.equals(this.returnSize(), other.returnSize()) && Objects.equals(this.totalSize(), other.totalSize());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostCategoriesResponse").add("NextPageToken", (Object)this.nextPageToken()).add("CostCategoryNames", this.hasCostCategoryNames() ? this.costCategoryNames() : null).add("CostCategoryValues", this.hasCostCategoryValues() ? this.costCategoryValues() : null).add("ReturnSize", (Object)this.returnSize()).add("TotalSize", (Object)this.totalSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "CostCategoryNames": {
                return Optional.ofNullable(clazz.cast(this.costCategoryNames()));
            }
            case "CostCategoryValues": {
                return Optional.ofNullable(clazz.cast(this.costCategoryValues()));
            }
            case "ReturnSize": {
                return Optional.ofNullable(clazz.cast(this.returnSize()));
            }
            case "TotalSize": {
                return Optional.ofNullable(clazz.cast(this.totalSize()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCostCategoriesResponse, T> g) {
        return obj -> g.apply((GetCostCategoriesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private String nextPageToken;
        private List<String> costCategoryNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> costCategoryValues = DefaultSdkAutoConstructList.getInstance();
        private Integer returnSize;
        private Integer totalSize;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostCategoriesResponse model) {
            super(model);
            this.nextPageToken(model.nextPageToken);
            this.costCategoryNames(model.costCategoryNames);
            this.costCategoryValues(model.costCategoryValues);
            this.returnSize(model.returnSize);
            this.totalSize(model.totalSize);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        @Transient
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Collection<String> getCostCategoryNames() {
            if (this.costCategoryNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.costCategoryNames;
        }

        public final void setCostCategoryNames(Collection<String> costCategoryNames) {
            this.costCategoryNames = CostCategoryNamesListCopier.copy(costCategoryNames);
        }

        @Override
        @Transient
        public final Builder costCategoryNames(Collection<String> costCategoryNames) {
            this.costCategoryNames = CostCategoryNamesListCopier.copy(costCategoryNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder costCategoryNames(String ... costCategoryNames) {
            this.costCategoryNames(Arrays.asList(costCategoryNames));
            return this;
        }

        public final Collection<String> getCostCategoryValues() {
            if (this.costCategoryValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.costCategoryValues;
        }

        public final void setCostCategoryValues(Collection<String> costCategoryValues) {
            this.costCategoryValues = CostCategoryValuesListCopier.copy(costCategoryValues);
        }

        @Override
        @Transient
        public final Builder costCategoryValues(Collection<String> costCategoryValues) {
            this.costCategoryValues = CostCategoryValuesListCopier.copy(costCategoryValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder costCategoryValues(String ... costCategoryValues) {
            this.costCategoryValues(Arrays.asList(costCategoryValues));
            return this;
        }

        public final Integer getReturnSize() {
            return this.returnSize;
        }

        public final void setReturnSize(Integer returnSize) {
            this.returnSize = returnSize;
        }

        @Override
        @Transient
        public final Builder returnSize(Integer returnSize) {
            this.returnSize = returnSize;
            return this;
        }

        public final Integer getTotalSize() {
            return this.totalSize;
        }

        public final void setTotalSize(Integer totalSize) {
            this.totalSize = totalSize;
        }

        @Override
        @Transient
        public final Builder totalSize(Integer totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        @Override
        public GetCostCategoriesResponse build() {
            return new GetCostCategoriesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostCategoriesResponse> {
        public Builder nextPageToken(String var1);

        public Builder costCategoryNames(Collection<String> var1);

        public Builder costCategoryNames(String ... var1);

        public Builder costCategoryValues(Collection<String> var1);

        public Builder costCategoryValues(String ... var1);

        public Builder returnSize(Integer var1);

        public Builder totalSize(Integer var1);
    }
}

