/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ESInstanceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ESInstanceDetails> {
    private static final SdkField<String> INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceClass").getter(ESInstanceDetails.getter(ESInstanceDetails::instanceClass)).setter(ESInstanceDetails.setter(Builder::instanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceClass").build()}).build();
    private static final SdkField<String> INSTANCE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceSize").getter(ESInstanceDetails.getter(ESInstanceDetails::instanceSize)).setter(ESInstanceDetails.setter(Builder::instanceSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceSize").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Region").getter(ESInstanceDetails.getter(ESInstanceDetails::region)).setter(ESInstanceDetails.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()}).build();
    private static final SdkField<Boolean> CURRENT_GENERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CurrentGeneration").getter(ESInstanceDetails.getter(ESInstanceDetails::currentGeneration)).setter(ESInstanceDetails.setter(Builder::currentGeneration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentGeneration").build()}).build();
    private static final SdkField<Boolean> SIZE_FLEX_ELIGIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SizeFlexEligible").getter(ESInstanceDetails.getter(ESInstanceDetails::sizeFlexEligible)).setter(ESInstanceDetails.setter(Builder::sizeFlexEligible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeFlexEligible").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_CLASS_FIELD, INSTANCE_SIZE_FIELD, REGION_FIELD, CURRENT_GENERATION_FIELD, SIZE_FLEX_ELIGIBLE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceClass;
    private final String instanceSize;
    private final String region;
    private final Boolean currentGeneration;
    private final Boolean sizeFlexEligible;

    private ESInstanceDetails(BuilderImpl builder) {
        this.instanceClass = builder.instanceClass;
        this.instanceSize = builder.instanceSize;
        this.region = builder.region;
        this.currentGeneration = builder.currentGeneration;
        this.sizeFlexEligible = builder.sizeFlexEligible;
    }

    public final String instanceClass() {
        return this.instanceClass;
    }

    public final String instanceSize() {
        return this.instanceSize;
    }

    public final String region() {
        return this.region;
    }

    public final Boolean currentGeneration() {
        return this.currentGeneration;
    }

    public final Boolean sizeFlexEligible() {
        return this.sizeFlexEligible;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentGeneration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeFlexEligible());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ESInstanceDetails)) {
            return false;
        }
        ESInstanceDetails other = (ESInstanceDetails)obj;
        return Objects.equals(this.instanceClass(), other.instanceClass()) && Objects.equals(this.instanceSize(), other.instanceSize()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.currentGeneration(), other.currentGeneration()) && Objects.equals(this.sizeFlexEligible(), other.sizeFlexEligible());
    }

    public final String toString() {
        return ToString.builder((String)"ESInstanceDetails").add("InstanceClass", (Object)this.instanceClass()).add("InstanceSize", (Object)this.instanceSize()).add("Region", (Object)this.region()).add("CurrentGeneration", (Object)this.currentGeneration()).add("SizeFlexEligible", (Object)this.sizeFlexEligible()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceClass": {
                return Optional.ofNullable(clazz.cast(this.instanceClass()));
            }
            case "InstanceSize": {
                return Optional.ofNullable(clazz.cast(this.instanceSize()));
            }
            case "Region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "CurrentGeneration": {
                return Optional.ofNullable(clazz.cast(this.currentGeneration()));
            }
            case "SizeFlexEligible": {
                return Optional.ofNullable(clazz.cast(this.sizeFlexEligible()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ESInstanceDetails, T> g) {
        return obj -> g.apply((ESInstanceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceClass;
        private String instanceSize;
        private String region;
        private Boolean currentGeneration;
        private Boolean sizeFlexEligible;

        private BuilderImpl() {
        }

        private BuilderImpl(ESInstanceDetails model) {
            this.instanceClass(model.instanceClass);
            this.instanceSize(model.instanceSize);
            this.region(model.region);
            this.currentGeneration(model.currentGeneration);
            this.sizeFlexEligible(model.sizeFlexEligible);
        }

        public final String getInstanceClass() {
            return this.instanceClass;
        }

        public final void setInstanceClass(String instanceClass) {
            this.instanceClass = instanceClass;
        }

        @Override
        @Transient
        public final Builder instanceClass(String instanceClass) {
            this.instanceClass = instanceClass;
            return this;
        }

        public final String getInstanceSize() {
            return this.instanceSize;
        }

        public final void setInstanceSize(String instanceSize) {
            this.instanceSize = instanceSize;
        }

        @Override
        @Transient
        public final Builder instanceSize(String instanceSize) {
            this.instanceSize = instanceSize;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final Boolean getCurrentGeneration() {
            return this.currentGeneration;
        }

        public final void setCurrentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
        }

        @Override
        @Transient
        public final Builder currentGeneration(Boolean currentGeneration) {
            this.currentGeneration = currentGeneration;
            return this;
        }

        public final Boolean getSizeFlexEligible() {
            return this.sizeFlexEligible;
        }

        public final void setSizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
        }

        @Override
        @Transient
        public final Builder sizeFlexEligible(Boolean sizeFlexEligible) {
            this.sizeFlexEligible = sizeFlexEligible;
            return this;
        }

        public ESInstanceDetails build() {
            return new ESInstanceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ESInstanceDetails> {
        public Builder instanceClass(String var1);

        public Builder instanceSize(String var1);

        public Builder region(String var1);

        public Builder currentGeneration(Boolean var1);

        public Builder sizeFlexEligible(Boolean var1);
    }
}

