/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.EBSResourceUtilization;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EC2ResourceUtilization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EC2ResourceUtilization> {
    private static final SdkField<String> MAX_CPU_UTILIZATION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxCpuUtilizationPercentage").getter(EC2ResourceUtilization.getter(EC2ResourceUtilization::maxCpuUtilizationPercentage)).setter(EC2ResourceUtilization.setter(Builder::maxCpuUtilizationPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCpuUtilizationPercentage").build()}).build();
    private static final SdkField<String> MAX_MEMORY_UTILIZATION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxMemoryUtilizationPercentage").getter(EC2ResourceUtilization.getter(EC2ResourceUtilization::maxMemoryUtilizationPercentage)).setter(EC2ResourceUtilization.setter(Builder::maxMemoryUtilizationPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMemoryUtilizationPercentage").build()}).build();
    private static final SdkField<String> MAX_STORAGE_UTILIZATION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxStorageUtilizationPercentage").getter(EC2ResourceUtilization.getter(EC2ResourceUtilization::maxStorageUtilizationPercentage)).setter(EC2ResourceUtilization.setter(Builder::maxStorageUtilizationPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageUtilizationPercentage").build()}).build();
    private static final SdkField<EBSResourceUtilization> EBS_RESOURCE_UTILIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EBSResourceUtilization").getter(EC2ResourceUtilization.getter(EC2ResourceUtilization::ebsResourceUtilization)).setter(EC2ResourceUtilization.setter(Builder::ebsResourceUtilization)).constructor(EBSResourceUtilization::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EBSResourceUtilization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CPU_UTILIZATION_PERCENTAGE_FIELD, MAX_MEMORY_UTILIZATION_PERCENTAGE_FIELD, MAX_STORAGE_UTILIZATION_PERCENTAGE_FIELD, EBS_RESOURCE_UTILIZATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String maxCpuUtilizationPercentage;
    private final String maxMemoryUtilizationPercentage;
    private final String maxStorageUtilizationPercentage;
    private final EBSResourceUtilization ebsResourceUtilization;

    private EC2ResourceUtilization(BuilderImpl builder) {
        this.maxCpuUtilizationPercentage = builder.maxCpuUtilizationPercentage;
        this.maxMemoryUtilizationPercentage = builder.maxMemoryUtilizationPercentage;
        this.maxStorageUtilizationPercentage = builder.maxStorageUtilizationPercentage;
        this.ebsResourceUtilization = builder.ebsResourceUtilization;
    }

    public String maxCpuUtilizationPercentage() {
        return this.maxCpuUtilizationPercentage;
    }

    public String maxMemoryUtilizationPercentage() {
        return this.maxMemoryUtilizationPercentage;
    }

    public String maxStorageUtilizationPercentage() {
        return this.maxStorageUtilizationPercentage;
    }

    public EBSResourceUtilization ebsResourceUtilization() {
        return this.ebsResourceUtilization;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCpuUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMemoryUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStorageUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsResourceUtilization());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2ResourceUtilization)) {
            return false;
        }
        EC2ResourceUtilization other = (EC2ResourceUtilization)obj;
        return Objects.equals(this.maxCpuUtilizationPercentage(), other.maxCpuUtilizationPercentage()) && Objects.equals(this.maxMemoryUtilizationPercentage(), other.maxMemoryUtilizationPercentage()) && Objects.equals(this.maxStorageUtilizationPercentage(), other.maxStorageUtilizationPercentage()) && Objects.equals(this.ebsResourceUtilization(), other.ebsResourceUtilization());
    }

    public String toString() {
        return ToString.builder((String)"EC2ResourceUtilization").add("MaxCpuUtilizationPercentage", (Object)this.maxCpuUtilizationPercentage()).add("MaxMemoryUtilizationPercentage", (Object)this.maxMemoryUtilizationPercentage()).add("MaxStorageUtilizationPercentage", (Object)this.maxStorageUtilizationPercentage()).add("EBSResourceUtilization", (Object)this.ebsResourceUtilization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxCpuUtilizationPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxCpuUtilizationPercentage()));
            }
            case "MaxMemoryUtilizationPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxMemoryUtilizationPercentage()));
            }
            case "MaxStorageUtilizationPercentage": {
                return Optional.ofNullable(clazz.cast(this.maxStorageUtilizationPercentage()));
            }
            case "EBSResourceUtilization": {
                return Optional.ofNullable(clazz.cast(this.ebsResourceUtilization()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2ResourceUtilization, T> g) {
        return obj -> g.apply((EC2ResourceUtilization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String maxCpuUtilizationPercentage;
        private String maxMemoryUtilizationPercentage;
        private String maxStorageUtilizationPercentage;
        private EBSResourceUtilization ebsResourceUtilization;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2ResourceUtilization model) {
            this.maxCpuUtilizationPercentage(model.maxCpuUtilizationPercentage);
            this.maxMemoryUtilizationPercentage(model.maxMemoryUtilizationPercentage);
            this.maxStorageUtilizationPercentage(model.maxStorageUtilizationPercentage);
            this.ebsResourceUtilization(model.ebsResourceUtilization);
        }

        public final String getMaxCpuUtilizationPercentage() {
            return this.maxCpuUtilizationPercentage;
        }

        @Override
        public final Builder maxCpuUtilizationPercentage(String maxCpuUtilizationPercentage) {
            this.maxCpuUtilizationPercentage = maxCpuUtilizationPercentage;
            return this;
        }

        public final void setMaxCpuUtilizationPercentage(String maxCpuUtilizationPercentage) {
            this.maxCpuUtilizationPercentage = maxCpuUtilizationPercentage;
        }

        public final String getMaxMemoryUtilizationPercentage() {
            return this.maxMemoryUtilizationPercentage;
        }

        @Override
        public final Builder maxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage) {
            this.maxMemoryUtilizationPercentage = maxMemoryUtilizationPercentage;
            return this;
        }

        public final void setMaxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage) {
            this.maxMemoryUtilizationPercentage = maxMemoryUtilizationPercentage;
        }

        public final String getMaxStorageUtilizationPercentage() {
            return this.maxStorageUtilizationPercentage;
        }

        @Override
        public final Builder maxStorageUtilizationPercentage(String maxStorageUtilizationPercentage) {
            this.maxStorageUtilizationPercentage = maxStorageUtilizationPercentage;
            return this;
        }

        public final void setMaxStorageUtilizationPercentage(String maxStorageUtilizationPercentage) {
            this.maxStorageUtilizationPercentage = maxStorageUtilizationPercentage;
        }

        public final EBSResourceUtilization.Builder getEbsResourceUtilization() {
            return this.ebsResourceUtilization != null ? this.ebsResourceUtilization.toBuilder() : null;
        }

        @Override
        public final Builder ebsResourceUtilization(EBSResourceUtilization ebsResourceUtilization) {
            this.ebsResourceUtilization = ebsResourceUtilization;
            return this;
        }

        public final void setEbsResourceUtilization(EBSResourceUtilization.BuilderImpl ebsResourceUtilization) {
            this.ebsResourceUtilization = ebsResourceUtilization != null ? ebsResourceUtilization.build() : null;
        }

        public EC2ResourceUtilization build() {
            return new EC2ResourceUtilization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EC2ResourceUtilization> {
        public Builder maxCpuUtilizationPercentage(String var1);

        public Builder maxMemoryUtilizationPercentage(String var1);

        public Builder maxStorageUtilizationPercentage(String var1);

        public Builder ebsResourceUtilization(EBSResourceUtilization var1);

        default public Builder ebsResourceUtilization(Consumer<EBSResourceUtilization.Builder> ebsResourceUtilization) {
            return this.ebsResourceUtilization((EBSResourceUtilization)((EBSResourceUtilization.Builder)EBSResourceUtilization.builder().applyMutation(ebsResourceUtilization)).build());
        }
    }
}

