/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.model.BillExpirationException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DataUnavailableException;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.costexplorer.model.LimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;
import software.amazon.awssdk.services.costexplorer.model.RequestChangedException;
import software.amazon.awssdk.services.costexplorer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.costexplorer.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.costexplorer.model.UnresolvableUsageUnitException;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansCoverageIterable;
import software.amazon.awssdk.services.costexplorer.paginators.GetSavingsPlansUtilizationDetailsIterable;
import software.amazon.awssdk.services.costexplorer.paginators.ListCostCategoryDefinitionsIterable;
import software.amazon.awssdk.services.costexplorer.transform.CreateCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DescribeCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageWithResourcesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetDimensionValuesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetRightsizingRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationDetailsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetUsageForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostCategoryDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateCostCategoryDefinitionRequestMarshaller;

@SdkInternalApi
final class DefaultCostExplorerClient
implements CostExplorerClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCostExplorerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "ce";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateCostCategoryDefinitionResponse createCostCategoryDefinition(CreateCostCategoryDefinitionRequest createCostCategoryDefinitionRequest) throws ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCostCategoryDefinition");
            CreateCostCategoryDefinitionResponse createCostCategoryDefinitionResponse = (CreateCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createCostCategoryDefinitionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createCostCategoryDefinitionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, createCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest deleteCostCategoryDefinitionRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCostCategoryDefinition");
            DeleteCostCategoryDefinitionResponse deleteCostCategoryDefinitionResponse = (DeleteCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteCostCategoryDefinitionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteCostCategoryDefinitionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, deleteCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeCostCategoryDefinitionResponse describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest describeCostCategoryDefinitionRequest) throws ResourceNotFoundException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCostCategoryDefinition");
            DescribeCostCategoryDefinitionResponse describeCostCategoryDefinitionResponse = (DescribeCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeCostCategoryDefinitionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DescribeCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeCostCategoryDefinitionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, describeCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostAndUsageResponse getCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsage");
            GetCostAndUsageResponse getCostAndUsageResponse = (GetCostAndUsageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostAndUsageRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetCostAndUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostAndUsageResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getCostAndUsageRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostAndUsageWithResourcesResponse getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest getCostAndUsageWithResourcesRequest) throws DataUnavailableException, LimitExceededException, BillExpirationException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageWithResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsageWithResources");
            GetCostAndUsageWithResourcesResponse getCostAndUsageWithResourcesResponse = (GetCostAndUsageWithResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsageWithResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostAndUsageWithResourcesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetCostAndUsageWithResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostAndUsageWithResourcesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getCostAndUsageWithResourcesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetCostForecastResponse getCostForecast(GetCostForecastRequest getCostForecastRequest) throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostForecast");
            GetCostForecastResponse getCostForecastResponse = (GetCostForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getCostForecastRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetCostForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getCostForecastResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getCostForecastRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDimensionValuesResponse getDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDimensionValuesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDimensionValues");
            GetDimensionValuesResponse getDimensionValuesResponse = (GetDimensionValuesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDimensionValues").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDimensionValuesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetDimensionValuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDimensionValuesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getDimensionValuesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationCoverageResponse getReservationCoverage(GetReservationCoverageRequest getReservationCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationCoverageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationCoverage");
            GetReservationCoverageResponse getReservationCoverageResponse = (GetReservationCoverageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationCoverage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationCoverageRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationCoverageResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getReservationCoverageRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationPurchaseRecommendationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationPurchaseRecommendation");
            GetReservationPurchaseRecommendationResponse getReservationPurchaseRecommendationResponse = (GetReservationPurchaseRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationPurchaseRecommendation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationPurchaseRecommendationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationPurchaseRecommendationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getReservationPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReservationUtilizationResponse getReservationUtilization(GetReservationUtilizationRequest getReservationUtilizationRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationUtilizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationUtilization");
            GetReservationUtilizationResponse getReservationUtilizationResponse = (GetReservationUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationUtilization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getReservationUtilizationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetReservationUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReservationUtilizationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getReservationUtilizationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRightsizingRecommendationResponse getRightsizingRecommendation(GetRightsizingRecommendationRequest getRightsizingRecommendationRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRightsizingRecommendationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRightsizingRecommendation");
            GetRightsizingRecommendationResponse getRightsizingRecommendationResponse = (GetRightsizingRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRightsizingRecommendation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getRightsizingRecommendationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetRightsizingRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRightsizingRecommendationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getRightsizingRecommendationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansCoverageResponse getSavingsPlansCoverage(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansCoverageResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansCoverage");
            GetSavingsPlansCoverageResponse getSavingsPlansCoverageResponse = (GetSavingsPlansCoverageResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansCoverage").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansCoverageRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansCoverageResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansCoverageRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetSavingsPlansCoverageIterable getSavingsPlansCoveragePaginator(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return new GetSavingsPlansCoverageIterable(this, this.applyPaginatorUserAgent(getSavingsPlansCoverageRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest getSavingsPlansPurchaseRecommendationRequest) throws LimitExceededException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansPurchaseRecommendationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansPurchaseRecommendation");
            GetSavingsPlansPurchaseRecommendationResponse getSavingsPlansPurchaseRecommendationResponse = (GetSavingsPlansPurchaseRecommendationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansPurchaseRecommendation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansPurchaseRecommendationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansPurchaseRecommendationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansUtilizationResponse getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest getSavingsPlansUtilizationRequest) throws LimitExceededException, DataUnavailableException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilization");
            GetSavingsPlansUtilizationResponse getSavingsPlansUtilizationResponse = (GetSavingsPlansUtilizationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilization").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansUtilizationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansUtilizationResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansUtilizationRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilizationDetails");
            GetSavingsPlansUtilizationDetailsResponse getSavingsPlansUtilizationDetailsResponse = (GetSavingsPlansUtilizationDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilizationDetails").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getSavingsPlansUtilizationDetailsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetSavingsPlansUtilizationDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSavingsPlansUtilizationDetailsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getSavingsPlansUtilizationDetailsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public GetSavingsPlansUtilizationDetailsIterable getSavingsPlansUtilizationDetailsPaginator(GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) throws LimitExceededException, DataUnavailableException, InvalidNextTokenException, AwsServiceException, SdkClientException, CostExplorerException {
        return new GetSavingsPlansUtilizationDetailsIterable(this, this.applyPaginatorUserAgent(getSavingsPlansUtilizationDetailsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTagsResponse getTags(GetTagsRequest getTagsRequest) throws LimitExceededException, BillExpirationException, DataUnavailableException, InvalidNextTokenException, RequestChangedException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTagsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTags");
            GetTagsResponse getTagsResponse = (GetTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTags").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getTagsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTagsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getTagsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetUsageForecastResponse getUsageForecast(GetUsageForecastRequest getUsageForecastRequest) throws LimitExceededException, DataUnavailableException, UnresolvableUsageUnitException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsageForecastResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsageForecast");
            GetUsageForecastResponse getUsageForecastResponse = (GetUsageForecastResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsageForecast").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getUsageForecastRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetUsageForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getUsageForecastResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, getUsageForecastRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCostCategoryDefinitionsResponse listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostCategoryDefinitionsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostCategoryDefinitions");
            ListCostCategoryDefinitionsResponse listCostCategoryDefinitionsResponse = (ListCostCategoryDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostCategoryDefinitions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listCostCategoryDefinitionsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListCostCategoryDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCostCategoryDefinitionsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, listCostCategoryDefinitionsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListCostCategoryDefinitionsIterable listCostCategoryDefinitionsPaginator(ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) throws LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        return new ListCostCategoryDefinitionsIterable(this, this.applyPaginatorUserAgent(listCostCategoryDefinitionsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateCostCategoryDefinitionResponse updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest updateCostCategoryDefinitionRequest) throws ResourceNotFoundException, ServiceQuotaExceededException, LimitExceededException, AwsServiceException, SdkClientException, CostExplorerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCostCategoryDefinitionResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCostCategoryDefinition");
            UpdateCostCategoryDefinitionResponse updateCostCategoryDefinitionResponse = (UpdateCostCategoryDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCostCategoryDefinition").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateCostCategoryDefinitionRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateCostCategoryDefinitionResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultCostExplorerClient.resolveMetricPublishers(this.clientConfiguration, updateCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CostExplorerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestChangedException").exceptionBuilderSupplier(RequestChangedException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DataUnavailableException").exceptionBuilderSupplier(DataUnavailableException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").exceptionBuilderSupplier(InvalidNextTokenException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceededException").exceptionBuilderSupplier(LimitExceededException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BillExpirationException").exceptionBuilderSupplier(BillExpirationException::builder).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CostExplorerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.59").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CostExplorerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

