/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDimensionValuesRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetDimensionValuesRequest.Builder, GetDimensionValuesRequest> {
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDimensionValuesRequest::searchString)).setter(setter(Builder::searchString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()).build();

    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetDimensionValuesRequest::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDimensionValuesRequest::dimensionAsString)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dimension").build()).build();

    private static final SdkField<String> CONTEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDimensionValuesRequest::contextAsString)).setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Context").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetDimensionValuesRequest::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_STRING_FIELD,
            TIME_PERIOD_FIELD, DIMENSION_FIELD, CONTEXT_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final String searchString;

    private final DateInterval timePeriod;

    private final String dimension;

    private final String context;

    private final String nextPageToken;

    private GetDimensionValuesRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.dimension = builder.dimension;
        this.context = builder.context;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The value that you want to search the filter values for.
     * </p>
     * 
     * @return The value that you want to search the filter values for.
     */
    public String searchString() {
        return searchString;
    }

    /**
     * <p>
     * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
     * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     * </p>
     * 
     * @return The start and end dates for retrieving the dimension values. The start date is inclusive, but the end
     *         date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     *         <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     *         including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     */
    public DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
     * more information, see <code>Context</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimension} will
     * return {@link Dimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionAsString}.
     * </p>
     * 
     * @return The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>.
     *         For more information, see <code>Context</code>.
     * @see Dimension
     */
    public Dimension dimension() {
        return Dimension.fromValue(dimension);
    }

    /**
     * <p>
     * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
     * more information, see <code>Context</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dimension} will
     * return {@link Dimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #dimensionAsString}.
     * </p>
     * 
     * @return The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>.
     *         For more information, see <code>Context</code>.
     * @see Dimension
     */
    public String dimensionAsString() {
        return dimension;
    }

    /**
     * <p>
     * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
     * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
     * </p>
     * <p>
     * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the AWS ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
     * Instances and Standard Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE - The AWS service such as Amazon DynamoDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     * response for this operation includes a unit attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14
     * days for EC2-Compute Service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     * <code>SingleAZ</code> and <code>MultiAZ</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the AWS ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability
     * Zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     * </p>
     * </li>
     * <li>
     * <p>
     * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the AWS ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #context} will
     * return {@link Context#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextAsString}.
     * </p>
     * 
     * @return The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     *         <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     *         <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     *         <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>,
     *         the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
     *         <p>
     *         If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
     *         searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web
     *         Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the AWS ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
     *         On-Demand Instances and Standard Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE - The AWS service such as Amazon DynamoDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     *         <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     *         response for this operation includes a unit attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for
     *         last 14 days for EC2-Compute Service.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     *         <code>SingleAZ</code> and <code>MultiAZ</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the AWS ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The AWS Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
     *         Availability Zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The AWS Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the AWS ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
     *         </p>
     *         </li>
     * @see Context
     */
    public Context context() {
        return Context.fromValue(context);
    }

    /**
     * <p>
     * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
     * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
     * </p>
     * <p>
     * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web Services.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the AWS ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include On-Demand
     * Instances and Standard Reserved Instances.
     * </p>
     * </li>
     * <li>
     * <p>
     * SERVICE - The AWS service such as Amazon DynamoDB.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     * </p>
     * </li>
     * <li>
     * <p>
     * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     * response for this operation includes a unit attribute.
     * </p>
     * </li>
     * <li>
     * <p>
     * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     * </p>
     * </li>
     * <li>
     * <p>
     * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last 14
     * days for EC2-Compute Service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     * <code>SingleAZ</code> and <code>MultiAZ</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the AWS ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single Availability
     * Zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     * </p>
     * </li>
     * <li>
     * <p>
     * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     * </p>
     * <ul>
     * <li>
     * <p>
     * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     * </p>
     * </li>
     * <li>
     * <p>
     * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     * </p>
     * </li>
     * <li>
     * <p>
     * REGION - The AWS Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
     * value field contains the AWS ID of the member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #context} will
     * return {@link Context#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #contextAsString}.
     * </p>
     * 
     * @return The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
     *         <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
     *         <code>RESERVATIONS</code>, the resulting dimension values can be used in the
     *         <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>,
     *         the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
     *         <p>
     *         If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
     *         searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web
     *         Services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the AWS ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
     *         On-Demand Instances and Standard Reserved Instances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SERVICE - The AWS service such as Amazon DynamoDB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
     *         <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
     *         response for this operation includes a unit attribute.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for
     *         last 14 days for EC2-Compute Service.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AZ - The Availability Zone. An example is <code>us-east-1a</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
     *         <code>SingleAZ</code> and <code>MultiAZ</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the AWS ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The AWS Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
     *         Availability Zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         TENANCY - The tenancy of a resource. Examples are shared or dedicated.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         REGION - The AWS Region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account.
     *         The value field contains the AWS ID of the member account.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
     *         </p>
     *         </li>
     * @see Context
     */
    public String contextAsString() {
        return context;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. AWS provides the token when the response from a previous call has
     * more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. AWS provides the token when the response from a previous
     *         call has more results than the maximum page size.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(dimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contextAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDimensionValuesRequest)) {
            return false;
        }
        GetDimensionValuesRequest other = (GetDimensionValuesRequest) obj;
        return Objects.equals(searchString(), other.searchString()) && Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(dimensionAsString(), other.dimensionAsString())
                && Objects.equals(contextAsString(), other.contextAsString())
                && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetDimensionValuesRequest").add("SearchString", searchString()).add("TimePeriod", timePeriod())
                .add("Dimension", dimensionAsString()).add("Context", contextAsString()).add("NextPageToken", nextPageToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchString":
            return Optional.ofNullable(clazz.cast(searchString()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "Dimension":
            return Optional.ofNullable(clazz.cast(dimensionAsString()));
        case "Context":
            return Optional.ofNullable(clazz.cast(contextAsString()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDimensionValuesRequest, T> g) {
        return obj -> g.apply((GetDimensionValuesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetDimensionValuesRequest> {
        /**
         * <p>
         * The value that you want to search the filter values for.
         * </p>
         * 
         * @param searchString
         *        The value that you want to search the filter values for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchString(String searchString);

        /**
         * <p>
         * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
         * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * 
         * @param timePeriod
         *        The start and end dates for retrieving the dimension values. The start date is inclusive, but the end
         *        date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code>
         *        is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up
         *        to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
         * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
         * more information, see <code>Context</code>.
         * </p>
         * 
         * @param dimension
         *        The name of the dimension. Each <code>Dimension</code> is available for a different
         *        <code>Context</code>. For more information, see <code>Context</code>.
         * @see Dimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Dimension
         */
        Builder dimension(String dimension);

        /**
         * <p>
         * The name of the dimension. Each <code>Dimension</code> is available for a different <code>Context</code>. For
         * more information, see <code>Context</code>.
         * </p>
         * 
         * @param dimension
         *        The name of the dimension. Each <code>Dimension</code> is available for a different
         *        <code>Context</code>. For more information, see <code>Context</code>.
         * @see Dimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Dimension
         */
        Builder dimension(Dimension dimension);

        /**
         * <p>
         * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
         * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
         * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
         * </p>
         * <p>
         * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the AWS ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         * On-Demand Instances and Standard Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE - The AWS service such as Amazon DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
         * response for this operation includes a unit attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last
         * 14 days for EC2-Compute Service.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the AWS ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The AWS Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         * Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * </p>
         * </li>
         * <li>
         * <p>
         * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The AWS Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the AWS ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         * </p>
         * </li>
         * </ul>
         * 
         * @param context
         *        The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         *        <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set
         *        to <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         *        <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>
         *        , the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
         *        <p>
         *        If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web
         *        Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the AWS ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATION - The action performed. Examples include <code>RunInstance</code> and
         *        <code>CreateBucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         *        On-Demand Instances and Standard Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE - The AWS service such as Amazon DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         *        <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms.
         *        The response for this operation includes a unit attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available
         *        for last 14 days for EC2-Compute Service.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the AWS ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The AWS Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         *        Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The AWS Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the AWS ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         *        </p>
         *        </li>
         * @see Context
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Context
         */
        Builder context(String context);

        /**
         * <p>
         * The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         * <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set to
         * <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         * <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>, the
         * resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.
         * </p>
         * <p>
         * If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web Services.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the AWS ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * OPERATION - The action performed. Examples include <code>RunInstance</code> and <code>CreateBucket</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         * On-Demand Instances and Standard Reserved Instances.
         * </p>
         * </li>
         * <li>
         * <p>
         * SERVICE - The AWS service such as Amazon DynamoDB.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         * <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         * </p>
         * </li>
         * <li>
         * <p>
         * USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms. The
         * response for this operation includes a unit attribute.
         * </p>
         * </li>
         * <li>
         * <p>
         * RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         * </p>
         * </li>
         * <li>
         * <p>
         * RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available for last
         * 14 days for EC2-Compute Service.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         * <code>SingleAZ</code> and <code>MultiAZ</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the AWS ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The AWS Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         * Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         * </p>
         * </li>
         * <li>
         * <p>
         * TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for searching:
         * </p>
         * <ul>
         * <li>
         * <p>
         * SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         * </p>
         * </li>
         * <li>
         * <p>
         * PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         * </p>
         * </li>
         * <li>
         * <p>
         * REGION - The AWS Region.
         * </p>
         * </li>
         * <li>
         * <p>
         * INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member account. The
         * value field contains the AWS ID of the member account.
         * </p>
         * </li>
         * <li>
         * <p>
         * SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         * </p>
         * </li>
         * </ul>
         * 
         * @param context
         *        The context for the call to <code>GetDimensionValues</code>. This can be <code>RESERVATIONS</code> or
         *        <code>COST_AND_USAGE</code>. The default value is <code>COST_AND_USAGE</code>. If the context is set
         *        to <code>RESERVATIONS</code>, the resulting dimension values can be used in the
         *        <code>GetReservationUtilization</code> operation. If the context is set to <code>COST_AND_USAGE</code>
         *        , the resulting dimension values can be used in the <code>GetCostAndUsage</code> operation.</p>
         *        <p>
         *        If you set the context to <code>COST_AND_USAGE</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DATABASE_ENGINE - The Amazon Relational Database Service database. Examples are Aurora or MySQL.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LEGAL_ENTITY_NAME - The name of the organization that sells you AWS services, such as Amazon Web
         *        Services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the AWS ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATING_SYSTEM - The operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        OPERATION - The action performed. Examples include <code>RunInstance</code> and
         *        <code>CreateBucket</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PURCHASE_TYPE - The reservation type of the purchase to which this usage is related. Examples include
         *        On-Demand Instances and Standard Reserved Instances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SERVICE - The AWS service such as Amazon DynamoDB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE - The type of usage. An example is DataTransfer-In-Bytes. The response for the
         *        <code>GetDimensionValues</code> operation includes a unit attribute. Examples include GB and Hrs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        USAGE_TYPE_GROUP - The grouping of common usage types. An example is Amazon EC2: CloudWatch – Alarms.
         *        The response for this operation includes a unit attribute.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RECORD_TYPE - The different types of charges such as RI fees, usage costs, tax refunds, and credits.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RESOURCE_ID - The unique identifier of the resource. ResourceId is an opt-in feature only available
         *        for last 14 days for EC2-Compute Service.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>RESERVATIONS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AZ - The Availability Zone. An example is <code>us-east-1a</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CACHE_ENGINE - The Amazon ElastiCache operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        DEPLOYMENT_OPTION - The scope of Amazon Relational Database Service deployments. Valid values are
         *        <code>SingleAZ</code> and <code>MultiAZ</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE - The type of Amazon EC2 instance. An example is <code>m4.xlarge</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the AWS ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PLATFORM - The Amazon EC2 operating system. Examples are Windows or Linux.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The AWS Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SCOPE (Utilization only) - The scope of a Reserved Instance (RI). Values are regional or a single
         *        Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TAG (Coverage only) - The tags that are associated with a Reserved Instance (RI).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        TENANCY - The tenancy of a resource. Examples are shared or dedicated.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If you set the context to <code>SAVINGS_PLANS</code>, you can use the following dimensions for
         *        searching:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        SAVINGS_PLANS_TYPE - Type of Savings Plans (EC2 Instance or Compute)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PAYMENT_OPTION - Payment option for the given Savings Plans (for example, All Upfront)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        REGION - The AWS Region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        INSTANCE_TYPE_FAMILY - The family of instances (For example, <code>m5</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LINKED_ACCOUNT - The description in the attribute map that includes the full name of the member
         *        account. The value field contains the AWS ID of the member account.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        SAVINGS_PLAN_ARN - The unique identifier for your Savings Plan
         *        </p>
         *        </li>
         * @see Context
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Context
         */
        Builder context(Context context);

        /**
         * <p>
         * The token to retrieve the next set of results. AWS provides the token when the response from a previous call
         * has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. AWS provides the token when the response from a
         *        previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String searchString;

        private DateInterval timePeriod;

        private String dimension;

        private String context;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDimensionValuesRequest model) {
            super(model);
            searchString(model.searchString);
            timePeriod(model.timePeriod);
            dimension(model.dimension);
            context(model.context);
            nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getDimension() {
            return dimension;
        }

        @Override
        public final Builder dimension(String dimension) {
            this.dimension = dimension;
            return this;
        }

        @Override
        public final Builder dimension(Dimension dimension) {
            this.dimension(dimension == null ? null : dimension.toString());
            return this;
        }

        public final void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public final String getContext() {
            return context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        @Override
        public final Builder context(Context context) {
            this.context(context == null ? null : context.toString());
            return this;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetDimensionValuesRequest build() {
            return new GetDimensionValuesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
