/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The time period that you want the usage and costs for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateInterval implements SdkPojo, Serializable, ToCopyableBuilder<DateInterval.Builder, DateInterval> {
    private static final SdkField<String> START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DateInterval::start)).setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Start").build()).build();

    private static final SdkField<String> END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DateInterval::end)).setter(setter(Builder::end))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("End").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_FIELD, END_FIELD));

    private static final long serialVersionUID = 1L;

    private final String start;

    private final String end;

    private DateInterval(BuilderImpl builder) {
        this.start = builder.start;
        this.end = builder.end;
    }

    /**
     * <p>
     * The beginning of the time period that you want the usage and costs for. The start date is inclusive. For example,
     * if <code>start</code> is <code>2017-01-01</code>, AWS retrieves cost and usage data starting at
     * <code>2017-01-01</code> up to the end date.
     * </p>
     * 
     * @return The beginning of the time period that you want the usage and costs for. The start date is inclusive. For
     *         example, if <code>start</code> is <code>2017-01-01</code>, AWS retrieves cost and usage data starting at
     *         <code>2017-01-01</code> up to the end date.
     */
    public String start() {
        return start;
    }

    /**
     * <p>
     * The end of the time period that you want the usage and costs for. The end date is exclusive. For example, if
     * <code>end</code> is <code>2017-05-01</code>, AWS retrieves cost and usage data from the start date up to, but not
     * including, <code>2017-05-01</code>.
     * </p>
     * 
     * @return The end of the time period that you want the usage and costs for. The end date is exclusive. For example,
     *         if <code>end</code> is <code>2017-05-01</code>, AWS retrieves cost and usage data from the start date up
     *         to, but not including, <code>2017-05-01</code>.
     */
    public String end() {
        return end;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(start());
        hashCode = 31 * hashCode + Objects.hashCode(end());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateInterval)) {
            return false;
        }
        DateInterval other = (DateInterval) obj;
        return Objects.equals(start(), other.start()) && Objects.equals(end(), other.end());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DateInterval").add("Start", start()).add("End", end()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Start":
            return Optional.ofNullable(clazz.cast(start()));
        case "End":
            return Optional.ofNullable(clazz.cast(end()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateInterval, T> g) {
        return obj -> g.apply((DateInterval) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateInterval> {
        /**
         * <p>
         * The beginning of the time period that you want the usage and costs for. The start date is inclusive. For
         * example, if <code>start</code> is <code>2017-01-01</code>, AWS retrieves cost and usage data starting at
         * <code>2017-01-01</code> up to the end date.
         * </p>
         * 
         * @param start
         *        The beginning of the time period that you want the usage and costs for. The start date is inclusive.
         *        For example, if <code>start</code> is <code>2017-01-01</code>, AWS retrieves cost and usage data
         *        starting at <code>2017-01-01</code> up to the end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(String start);

        /**
         * <p>
         * The end of the time period that you want the usage and costs for. The end date is exclusive. For example, if
         * <code>end</code> is <code>2017-05-01</code>, AWS retrieves cost and usage data from the start date up to, but
         * not including, <code>2017-05-01</code>.
         * </p>
         * 
         * @param end
         *        The end of the time period that you want the usage and costs for. The end date is exclusive. For
         *        example, if <code>end</code> is <code>2017-05-01</code>, AWS retrieves cost and usage data from the
         *        start date up to, but not including, <code>2017-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder end(String end);
    }

    static final class BuilderImpl implements Builder {
        private String start;

        private String end;

        private BuilderImpl() {
        }

        private BuilderImpl(DateInterval model) {
            start(model.start);
            end(model.end);
        }

        public final String getStart() {
            return start;
        }

        @Override
        public final Builder start(String start) {
            this.start = start;
            return this;
        }

        public final void setStart(String start) {
            this.start = start;
        }

        public final String getEnd() {
            return end;
        }

        @Override
        public final Builder end(String end) {
            this.end = end;
            return this;
        }

        public final void setEnd(String end) {
            this.end = end;
        }

        @Override
        public DateInterval build() {
            return new DateInterval(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
