/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.costexplorer.model.TagValues;

public class TagValuesUnmarshaller
implements Unmarshaller<TagValues, JsonUnmarshallerContext> {
    private static final TagValuesUnmarshaller INSTANCE = new TagValuesUnmarshaller();

    public TagValues unmarshall(JsonUnmarshallerContext context) throws Exception {
        TagValues.Builder tagValuesBuilder = TagValues.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Key", targetDepth)) {
                    context.nextToken();
                    tagValuesBuilder.key((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Values", targetDepth)) {
                    context.nextToken();
                    tagValuesBuilder.values(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (TagValues)tagValuesBuilder.build();
    }

    public static TagValuesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

