/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.ServiceSpecification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ServiceSpecificationMarshaller {
    private static final MarshallingInfo<StructuredPojo> EC2SPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EC2Specification").isBinary(false).build();
    private static final ServiceSpecificationMarshaller INSTANCE = new ServiceSpecificationMarshaller();

    private ServiceSpecificationMarshaller() {
    }

    public static ServiceSpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ServiceSpecification serviceSpecification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)serviceSpecification, (String)"serviceSpecification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)serviceSpecification.ec2Specification(), EC2SPECIFICATION_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

