/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.ReservationCoverageGroup;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReservationCoverageGroupMarshaller {
    private static final MarshallingInfo<Map> ATTRIBUTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attributes").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> COVERAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Coverage").isBinary(false).build();
    private static final ReservationCoverageGroupMarshaller INSTANCE = new ReservationCoverageGroupMarshaller();

    private ReservationCoverageGroupMarshaller() {
    }

    public static ReservationCoverageGroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReservationCoverageGroup reservationCoverageGroup, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reservationCoverageGroup, (String)"reservationCoverageGroup");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(reservationCoverageGroup.attributes(), ATTRIBUTES_BINDING);
            protocolMarshaller.marshall((Object)reservationCoverageGroup.coverage(), COVERAGE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

