/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.ReservationAggregates;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ReservationAggregatesMarshaller {
    private static final MarshallingInfo<String> UTILIZATIONPERCENTAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UtilizationPercentage").isBinary(false).build();
    private static final MarshallingInfo<String> PURCHASEDHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PurchasedHours").isBinary(false).build();
    private static final MarshallingInfo<String> TOTALACTUALHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalActualHours").isBinary(false).build();
    private static final MarshallingInfo<String> UNUSEDHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnusedHours").isBinary(false).build();
    private static final MarshallingInfo<String> ONDEMANDCOSTOFRIHOURSUSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OnDemandCostOfRIHoursUsed").isBinary(false).build();
    private static final MarshallingInfo<String> NETRISAVINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NetRISavings").isBinary(false).build();
    private static final MarshallingInfo<String> TOTALPOTENTIALRISAVINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalPotentialRISavings").isBinary(false).build();
    private static final MarshallingInfo<String> AMORTIZEDUPFRONTFEE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmortizedUpfrontFee").isBinary(false).build();
    private static final MarshallingInfo<String> AMORTIZEDRECURRINGFEE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AmortizedRecurringFee").isBinary(false).build();
    private static final MarshallingInfo<String> TOTALAMORTIZEDFEE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TotalAmortizedFee").isBinary(false).build();
    private static final ReservationAggregatesMarshaller INSTANCE = new ReservationAggregatesMarshaller();

    private ReservationAggregatesMarshaller() {
    }

    public static ReservationAggregatesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ReservationAggregates reservationAggregates, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)reservationAggregates, (String)"reservationAggregates");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)reservationAggregates.utilizationPercentage(), UTILIZATIONPERCENTAGE_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.purchasedHours(), PURCHASEDHOURS_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.totalActualHours(), TOTALACTUALHOURS_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.unusedHours(), UNUSEDHOURS_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.onDemandCostOfRIHoursUsed(), ONDEMANDCOSTOFRIHOURSUSED_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.netRISavings(), NETRISAVINGS_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.totalPotentialRISavings(), TOTALPOTENTIALRISAVINGS_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.amortizedUpfrontFee(), AMORTIZEDUPFRONTFEE_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.amortizedRecurringFee(), AMORTIZEDRECURRINGFEE_BINDING);
            protocolMarshaller.marshall((Object)reservationAggregates.totalAmortizedFee(), TOTALAMORTIZEDFEE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

