/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.RDSInstanceDetails;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RDSInstanceDetailsMarshaller {
    private static final MarshallingInfo<String> FAMILY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Family").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<String> REGION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Region").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASEENGINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseEngine").isBinary(false).build();
    private static final MarshallingInfo<String> DATABASEEDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseEdition").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTOPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DeploymentOption").isBinary(false).build();
    private static final MarshallingInfo<String> LICENSEMODEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LicenseModel").isBinary(false).build();
    private static final MarshallingInfo<Boolean> CURRENTGENERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CurrentGeneration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> SIZEFLEXELIGIBLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SizeFlexEligible").isBinary(false).build();
    private static final RDSInstanceDetailsMarshaller INSTANCE = new RDSInstanceDetailsMarshaller();

    private RDSInstanceDetailsMarshaller() {
    }

    public static RDSInstanceDetailsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RDSInstanceDetails rdsInstanceDetails, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rdsInstanceDetails, (String)"rdsInstanceDetails");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rdsInstanceDetails.family(), FAMILY_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.region(), REGION_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.databaseEngine(), DATABASEENGINE_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.databaseEdition(), DATABASEEDITION_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.deploymentOption(), DEPLOYMENTOPTION_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.licenseModel(), LICENSEMODEL_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.currentGeneration(), CURRENTGENERATION_BINDING);
            protocolMarshaller.marshall((Object)rdsInstanceDetails.sizeFlexEligible(), SIZEFLEXELIGIBLE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

