/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.MetricValue;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class MetricValueMarshaller {
    private static final MarshallingInfo<String> AMOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Amount").isBinary(false).build();
    private static final MarshallingInfo<String> UNIT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unit").isBinary(false).build();
    private static final MetricValueMarshaller INSTANCE = new MetricValueMarshaller();

    private MetricValueMarshaller() {
    }

    public static MetricValueMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MetricValue metricValue, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)metricValue, (String)"metricValue");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)metricValue.amount(), AMOUNT_BINDING);
            protocolMarshaller.marshall((Object)metricValue.unit(), UNIT_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

