/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.Group;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GroupMarshaller {
    private static final MarshallingInfo<List> KEYS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Keys").isBinary(false).build();
    private static final MarshallingInfo<Map> METRICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Metrics").isBinary(false).build();
    private static final GroupMarshaller INSTANCE = new GroupMarshaller();

    private GroupMarshaller() {
    }

    public static GroupMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Group group, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)group, (String)"group");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(group.keys(), KEYS_BINDING);
            protocolMarshaller.marshall(group.metrics(), METRICS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

