/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class GetReservationCoverageRequestModelMarshaller {
    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GroupBy").isBinary(false).build();
    private static final MarshallingInfo<String> GRANULARITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Granularity").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> FILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Filter").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTPAGETOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NextPageToken").isBinary(false).build();
    private static final GetReservationCoverageRequestModelMarshaller INSTANCE = new GetReservationCoverageRequestModelMarshaller();

    private GetReservationCoverageRequestModelMarshaller() {
    }

    public static GetReservationCoverageRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GetReservationCoverageRequest getReservationCoverageRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)getReservationCoverageRequest), (String)"getReservationCoverageRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)getReservationCoverageRequest.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall(getReservationCoverageRequest.groupBy(), GROUPBY_BINDING);
            protocolMarshaller.marshall((Object)getReservationCoverageRequest.granularityAsString(), GRANULARITY_BINDING);
            protocolMarshaller.marshall((Object)getReservationCoverageRequest.filter(), FILTER_BINDING);
            protocolMarshaller.marshall((Object)getReservationCoverageRequest.nextPageToken(), NEXTPAGETOKEN_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

