/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ExpressionMarshaller {
    private static final MarshallingInfo<List> OR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Or").isBinary(false).build();
    private static final MarshallingInfo<List> AND_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("And").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> NOT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Not").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Dimensions").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").isBinary(false).build();
    private static final ExpressionMarshaller INSTANCE = new ExpressionMarshaller();

    private ExpressionMarshaller() {
    }

    public static ExpressionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Expression expression, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)expression, (String)"expression");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(expression.or(), OR_BINDING);
            protocolMarshaller.marshall(expression.and(), AND_BINDING);
            protocolMarshaller.marshall((Object)expression.not(), NOT_BINDING);
            protocolMarshaller.marshall((Object)expression.dimensions(), DIMENSIONS_BINDING);
            protocolMarshaller.marshall((Object)expression.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

