/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.costexplorer.model.EC2Specification;

public class EC2SpecificationUnmarshaller
implements Unmarshaller<EC2Specification, JsonUnmarshallerContext> {
    private static final EC2SpecificationUnmarshaller INSTANCE = new EC2SpecificationUnmarshaller();

    public EC2Specification unmarshall(JsonUnmarshallerContext context) throws Exception {
        EC2Specification.Builder ec2SpecificationBuilder = EC2Specification.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("OfferingClass", targetDepth)) {
                    context.nextToken();
                    ec2SpecificationBuilder.offeringClass((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (EC2Specification)ec2SpecificationBuilder.build();
    }

    public static EC2SpecificationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

