/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.EC2Specification;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EC2SpecificationMarshaller {
    private static final MarshallingInfo<String> OFFERINGCLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("OfferingClass").isBinary(false).build();
    private static final EC2SpecificationMarshaller INSTANCE = new EC2SpecificationMarshaller();

    private EC2SpecificationMarshaller() {
    }

    public static EC2SpecificationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EC2Specification ec2Specification, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ec2Specification, (String)"ec2Specification");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ec2Specification.offeringClassAsString(), OFFERINGCLASS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

