/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.DimensionValues;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DimensionValuesMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").isBinary(false).build();
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").isBinary(false).build();
    private static final DimensionValuesMarshaller INSTANCE = new DimensionValuesMarshaller();

    private DimensionValuesMarshaller() {
    }

    public static DimensionValuesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DimensionValues dimensionValues, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dimensionValues, (String)"dimensionValues");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dimensionValues.keyAsString(), KEY_BINDING);
            protocolMarshaller.marshall(dimensionValues.values(), VALUES_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

