/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DateIntervalMarshaller {
    private static final MarshallingInfo<String> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Start").isBinary(false).build();
    private static final MarshallingInfo<String> END_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("End").isBinary(false).build();
    private static final DateIntervalMarshaller INSTANCE = new DateIntervalMarshaller();

    private DateIntervalMarshaller() {
    }

    public static DateIntervalMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DateInterval dateInterval, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)dateInterval, (String)"dateInterval");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)dateInterval.start(), START_BINDING);
            protocolMarshaller.marshall((Object)dateInterval.end(), END_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

