/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.Coverage;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CoverageMarshaller {
    private static final MarshallingInfo<StructuredPojo> COVERAGEHOURS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CoverageHours").isBinary(false).build();
    private static final CoverageMarshaller INSTANCE = new CoverageMarshaller();

    private CoverageMarshaller() {
    }

    public static CoverageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Coverage coverage, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)coverage, (String)"coverage");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)coverage.coverageHours(), COVERAGEHOURS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

