/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.costexplorer.model.CoverageByTime;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CoverageByTimeMarshaller {
    private static final MarshallingInfo<StructuredPojo> TIMEPERIOD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TimePeriod").isBinary(false).build();
    private static final MarshallingInfo<List> GROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Groups").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TOTAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Total").isBinary(false).build();
    private static final CoverageByTimeMarshaller INSTANCE = new CoverageByTimeMarshaller();

    private CoverageByTimeMarshaller() {
    }

    public static CoverageByTimeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CoverageByTime coverageByTime, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)coverageByTime, (String)"coverageByTime");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)coverageByTime.timePeriod(), TIMEPERIOD_BINDING);
            protocolMarshaller.marshall(coverageByTime.groups(), GROUPS_BINDING);
            protocolMarshaller.marshall((Object)coverageByTime.total(), TOTAL_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

